<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for LocationArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of Location
 * @subpackage Arrays
 */
class LocationArray extends AbstractStructArrayBase
{
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:Location
     * @var \StructType\Location[]
     */
    public $Location;
    /**
     * Constructor method for LocationArray
     * @uses LocationArray::setLocation()
     * @param \StructType\Location[] $location
     */
    public function __construct(array $location = array())
    {
        $this
            ->setLocation($location);
    }
    /**
     * Get Location value
     * @return \StructType\Location[]|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @throws \InvalidArgumentException
     * @param \StructType\Location[] $location
     * @return \ArrayType\LocationArray
     */
    public function setLocation(array $location = array())
    {
        foreach ($location as $locationArrayLocationItem) {
            // validation for constraint: itemType
            if (!$locationArrayLocationItem instanceof \StructType\Location) {
                throw new \InvalidArgumentException(sprintf('The Location property can only contain items of \StructType\Location, "%s" given', is_object($locationArrayLocationItem) ? get_class($locationArrayLocationItem) : gettype($locationArrayLocationItem)), __LINE__);
            }
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param \StructType\Location $item
     * @return \ArrayType\LocationArray
     */
    public function addToLocation(\StructType\Location $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Location) {
            throw new \InvalidArgumentException(sprintf('The Location property can only contain items of \StructType\Location, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Location|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Location|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Location|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Location|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Location|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Location
     */
    public function getAttributeName()
    {
        return 'Location';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\LocationArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
