<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ColorArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of colors
 * @subpackage Arrays
 */
class ColorArray extends AbstractStructArrayBase
{
    /**
     * The Color
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:Color
     * @var \StructType\Color[]
     */
    public $Color;
    /**
     * Constructor method for ColorArray
     * @uses ColorArray::setColor()
     * @param \StructType\Color[] $color
     */
    public function __construct(array $color = array())
    {
        $this
            ->setColor($color);
    }
    /**
     * Get Color value
     * @return \StructType\Color[]|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @throws \InvalidArgumentException
     * @param \StructType\Color[] $color
     * @return \ArrayType\ColorArray
     */
    public function setColor(array $color = array())
    {
        foreach ($color as $colorArrayColorItem) {
            // validation for constraint: itemType
            if (!$colorArrayColorItem instanceof \StructType\Color) {
                throw new \InvalidArgumentException(sprintf('The Color property can only contain items of \StructType\Color, "%s" given', is_object($colorArrayColorItem) ? get_class($colorArrayColorItem) : gettype($colorArrayColorItem)), __LINE__);
            }
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Add item to Color value
     * @throws \InvalidArgumentException
     * @param \StructType\Color $item
     * @return \ArrayType\ColorArray
     */
    public function addToColor(\StructType\Color $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Color) {
            throw new \InvalidArgumentException(sprintf('The Color property can only contain items of \StructType\Color, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Color[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Color|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Color|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Color|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Color|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Color|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Color
     */
    public function getAttributeName()
    {
        return 'Color';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ColorArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
