<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for AvailableChargeArray ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: An Array of charges
 * @subpackage Arrays
 */
class AvailableChargeArray extends AbstractStructArrayBase
{
    /**
     * The AvailableCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns1:AvailableCharge
     * @var \StructType\AvailableCharge[]
     */
    public $AvailableCharge;
    /**
     * Constructor method for AvailableChargeArray
     * @uses AvailableChargeArray::setAvailableCharge()
     * @param \StructType\AvailableCharge[] $availableCharge
     */
    public function __construct(array $availableCharge = array())
    {
        $this
            ->setAvailableCharge($availableCharge);
    }
    /**
     * Get AvailableCharge value
     * @return \StructType\AvailableCharge[]|null
     */
    public function getAvailableCharge()
    {
        return $this->AvailableCharge;
    }
    /**
     * Set AvailableCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AvailableCharge[] $availableCharge
     * @return \ArrayType\AvailableChargeArray
     */
    public function setAvailableCharge(array $availableCharge = array())
    {
        foreach ($availableCharge as $availableChargeArrayAvailableChargeItem) {
            // validation for constraint: itemType
            if (!$availableChargeArrayAvailableChargeItem instanceof \StructType\AvailableCharge) {
                throw new \InvalidArgumentException(sprintf('The AvailableCharge property can only contain items of \StructType\AvailableCharge, "%s" given', is_object($availableChargeArrayAvailableChargeItem) ? get_class($availableChargeArrayAvailableChargeItem) : gettype($availableChargeArrayAvailableChargeItem)), __LINE__);
            }
        }
        $this->AvailableCharge = $availableCharge;
        return $this;
    }
    /**
     * Add item to AvailableCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AvailableCharge $item
     * @return \ArrayType\AvailableChargeArray
     */
    public function addToAvailableCharge(\StructType\AvailableCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AvailableCharge) {
            throw new \InvalidArgumentException(sprintf('The AvailableCharge property can only contain items of \StructType\AvailableCharge, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AvailableCharge[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AvailableCharge|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AvailableCharge|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AvailableCharge|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AvailableCharge|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AvailableCharge|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AvailableCharge
     */
    public function getAttributeName()
    {
        return 'AvailableCharge';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\AvailableChargeArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
