<?php

namespace EnumType;

/**
 * This class stands for TypeVacature EnumType
 * @subpackage Enumerations
 */
class TypeVacature
{
    /**
     * Constant for value 'Uitbreiding__tijdelijk'
     * @return string 'Uitbreiding__tijdelijk'
     */
    const VALUE_UITBREIDING_TIJDELIJK = 'Uitbreiding__tijdelijk';
    /**
     * Constant for value 'Uitbreiding__vast'
     * @return string 'Uitbreiding__vast'
     */
    const VALUE_UITBREIDING_VAST = 'Uitbreiding__vast';
    /**
     * Constant for value 'Vervanging__tijdelijk'
     * @return string 'Vervanging__tijdelijk'
     */
    const VALUE_VERVANGING_TIJDELIJK = 'Vervanging__tijdelijk';
    /**
     * Constant for value 'Vervanging__vast'
     * @return string 'Vervanging__vast'
     */
    const VALUE_VERVANGING_VAST = 'Vervanging__vast';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UITBREIDING_TIJDELIJK
     * @uses self::VALUE_UITBREIDING_VAST
     * @uses self::VALUE_VERVANGING_TIJDELIJK
     * @uses self::VALUE_VERVANGING_VAST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UITBREIDING_TIJDELIJK,
            self::VALUE_UITBREIDING_VAST,
            self::VALUE_VERVANGING_TIJDELIJK,
            self::VALUE_VERVANGING_VAST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
