<?php

namespace EnumType;

/**
 * This class stands for Template EnumType
 * @subpackage Enumerations
 */
class Template
{
    /**
     * Constant for value 'Ja'
     * @return string 'Ja'
     */
    const VALUE_JA = 'Ja';
    /**
     * Constant for value 'Nee'
     * @return string 'Nee'
     */
    const VALUE_NEE = 'Nee';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_JA
     * @uses self::VALUE_NEE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_JA,
            self::VALUE_NEE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
