<?php

namespace web\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Openstaande ServiceType
 * @subpackage Services
 */
class Openstaande extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \web\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\web\StructType\Authentication $authentication, $nameSpace = 'https://webservices.daywize.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named OpenstaandeVacatures_Extern
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: https://webservices.daywize.nl
     * - SOAPHeaderTypes: \web\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: [Status != '_11__Vacature_afgesloten'andStatus != '_10__Vacature_vervuld'andDatumStartPublicatieExtern < '[%BeginOfCurrentDayUTC%]'and(DatumEindePublicatieExtern > '[%BeginOfCurrentDayUTC%]'or DatumEindePublicatieExtern = empty)]
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \web\StructType\OpenstaandeVacatures_Extern $parameters
     * @return \web\StructType\OpenstaandeVacatures_ExternResponse|bool
     */
    public function OpenstaandeVacatures_Extern(\web\StructType\OpenstaandeVacatures_Extern $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OpenstaandeVacatures_Extern($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OpenstaandeVacatures_Intern
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: https://webservices.daywize.nl
     * - SOAPHeaderTypes: \web\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: [Status != '_11__Vacature_afgesloten'andStatus != '_10__Vacature_vervuld'andDatumStartPublicatieIntern < '[%BeginOfCurrentDayUTC%]'and(DatumEindePublicatieIntern > '[%BeginOfCurrentDayUTC%]'or DatumEindePublicatieIntern = empty)]
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \web\StructType\OpenstaandeVacatures_Intern $parameters
     * @return \web\StructType\OpenstaandeVacatures_InternResponse|bool
     */
    public function OpenstaandeVacatures_Intern(\web\StructType\OpenstaandeVacatures_Intern $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OpenstaandeVacatures_Intern($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \web\StructType\OpenstaandeVacatures_ExternResponse|\web\StructType\OpenstaandeVacatures_InternResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
