<?php

namespace web\EnumType;

/**
 * This class stands for Status EnumType
 * @subpackage Enumerations
 */
class Status
{
    /**
     * Constant for value '_01__Nieuwe_vacaturemelding'
     * @return string '_01__Nieuwe_vacaturemelding'
     */
    const VALUE_01_NIEUWE_VACATUREMELDING = '_01__Nieuwe_vacaturemelding';
    /**
     * Constant for value '_02__Controle_mobiliteitskandidaten'
     * @return string '_02__Controle_mobiliteitskandidaten'
     */
    const VALUE_02_CONTROLE_MOBILITEITSKANDIDATEN = '_02__Controle_mobiliteitskandidaten';
    /**
     * Constant for value '_03__Controle_portefeuillekandidaten'
     * @return string '_03__Controle_portefeuillekandidaten'
     */
    const VALUE_03_CONTROLE_PORTEFEUILLEKANDIDATEN = '_03__Controle_portefeuillekandidaten';
    /**
     * Constant for value '_04__Akkoord_voor_publicatie'
     * @return string '_04__Akkoord_voor_publicatie'
     */
    const VALUE_04_AKKOORD_VOOR_PUBLICATIE = '_04__Akkoord_voor_publicatie';
    /**
     * Constant for value '_05__Interne_publicatie'
     * @return string '_05__Interne_publicatie'
     */
    const VALUE_05_INTERNE_PUBLICATIE = '_05__Interne_publicatie';
    /**
     * Constant for value '_06__Externe_publicatie'
     * @return string '_06__Externe_publicatie'
     */
    const VALUE_06_EXTERNE_PUBLICATIE = '_06__Externe_publicatie';
    /**
     * Constant for value '_07__Gelijktijdige_interne_en_externe_publicatie'
     * @return string '_07__Gelijktijdige_interne_en_externe_publicatie'
     */
    const VALUE_07_GELIJKTIJDIGE_INTERNE_EN_EXTERNE_PUBLICATIE = '_07__Gelijktijdige_interne_en_externe_publicatie';
    /**
     * Constant for value '_08__Publicatietermijn_verlengd'
     * @return string '_08__Publicatietermijn_verlengd'
     */
    const VALUE_08_PUBLICATIETERMIJN_VERLENGD = '_08__Publicatietermijn_verlengd';
    /**
     * Constant for value '_09__Reactietermijn_gesloten'
     * @return string '_09__Reactietermijn_gesloten'
     */
    const VALUE_09_REACTIETERMIJN_GESLOTEN = '_09__Reactietermijn_gesloten';
    /**
     * Constant for value '_10__Vacature_vervuld'
     * @return string '_10__Vacature_vervuld'
     */
    const VALUE_10_VACATURE_VERVULD = '_10__Vacature_vervuld';
    /**
     * Constant for value '_11__Vacature_afgesloten'
     * @return string '_11__Vacature_afgesloten'
     */
    const VALUE_11_VACATURE_AFGESLOTEN = '_11__Vacature_afgesloten';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_01_NIEUWE_VACATUREMELDING
     * @uses self::VALUE_02_CONTROLE_MOBILITEITSKANDIDATEN
     * @uses self::VALUE_03_CONTROLE_PORTEFEUILLEKANDIDATEN
     * @uses self::VALUE_04_AKKOORD_VOOR_PUBLICATIE
     * @uses self::VALUE_05_INTERNE_PUBLICATIE
     * @uses self::VALUE_06_EXTERNE_PUBLICATIE
     * @uses self::VALUE_07_GELIJKTIJDIGE_INTERNE_EN_EXTERNE_PUBLICATIE
     * @uses self::VALUE_08_PUBLICATIETERMIJN_VERLENGD
     * @uses self::VALUE_09_REACTIETERMIJN_GESLOTEN
     * @uses self::VALUE_10_VACATURE_VERVULD
     * @uses self::VALUE_11_VACATURE_AFGESLOTEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_01_NIEUWE_VACATUREMELDING,
            self::VALUE_02_CONTROLE_MOBILITEITSKANDIDATEN,
            self::VALUE_03_CONTROLE_PORTEFEUILLEKANDIDATEN,
            self::VALUE_04_AKKOORD_VOOR_PUBLICATIE,
            self::VALUE_05_INTERNE_PUBLICATIE,
            self::VALUE_06_EXTERNE_PUBLICATIE,
            self::VALUE_07_GELIJKTIJDIGE_INTERNE_EN_EXTERNE_PUBLICATIE,
            self::VALUE_08_PUBLICATIETERMIJN_VERLENGD,
            self::VALUE_09_REACTIETERMIJN_GESLOTEN,
            self::VALUE_10_VACATURE_VERVULD,
            self::VALUE_11_VACATURE_AFGESLOTEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
