<?php

namespace web\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SD_Functie StructType
 * @subpackage Structs
 */
class SD_Functie extends AbstractStructBase
{
    /**
     * The NaamTranslation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $NaamTranslation;
    /**
     * The Nummer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $Nummer;
    /**
     * Constructor method for SD_Functie
     * @uses SD_Functie::setNaamTranslation()
     * @uses SD_Functie::setNummer()
     * @param string $naamTranslation
     * @param string $nummer
     */
    public function __construct($naamTranslation = null, $nummer = null)
    {
        $this
            ->setNaamTranslation($naamTranslation)
            ->setNummer($nummer);
    }
    /**
     * Get NaamTranslation value
     * @return string|null
     */
    public function getNaamTranslation()
    {
        return $this->NaamTranslation;
    }
    /**
     * Set NaamTranslation value
     * @param string $naamTranslation
     * @return \web\StructType\SD_Functie
     */
    public function setNaamTranslation($naamTranslation = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($naamTranslation) && strlen($naamTranslation) > 200) || (is_array($naamTranslation) && count($naamTranslation) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($naamTranslation) ? strlen($naamTranslation) : count($naamTranslation)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($naamTranslation) && !is_string($naamTranslation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naamTranslation)), __LINE__);
        }
        $this->NaamTranslation = $naamTranslation;
        return $this;
    }
    /**
     * Get Nummer value
     * @return string|null
     */
    public function getNummer()
    {
        return $this->Nummer;
    }
    /**
     * Set Nummer value
     * @param string $nummer
     * @return \web\StructType\SD_Functie
     */
    public function setNummer($nummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nummer) && strlen($nummer) > 200) || (is_array($nummer) && count($nummer) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($nummer) ? strlen($nummer) : count($nummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nummer) && !is_string($nummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nummer)), __LINE__);
        }
        $this->Nummer = $nummer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \web\StructType\SD_Functie
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
