<?php

namespace web\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpenstaandeVacatures_Extern StructType
 * @subpackage Structs
 */
class OpenstaandeVacatures_Extern extends AbstractStructBase
{
    /**
     * The AantalFte
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AantalFte;
    /**
     * The AantalUren
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AantalUren;
    /**
     * The DatumStartPublicatieIntern
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumStartPublicatieIntern;
    /**
     * The DatumEindePublicatieIntern
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumEindePublicatieIntern;
    /**
     * The DatumInvulling
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumInvulling;
    /**
     * The DatumStartPublicatieExtern
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumStartPublicatieExtern;
    /**
     * The DatumEindePublicatieExtern
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumEindePublicatieExtern;
    /**
     * The DatumStartVacature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumStartVacature;
    /**
     * The DatumEindeVacature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumEindeVacature;
    /**
     * The Duur
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Duur;
    /**
     * The Duur_Dienstverband
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Duur_Dienstverband;
    /**
     * The Naam
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $Naam;
    /**
     * The Nummer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Nummer;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Standplaats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $Standplaats;
    /**
     * The Teaser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Teaser;
    /**
     * The TekstArbeidsvoorwaarden
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TekstArbeidsvoorwaarden;
    /**
     * The TekstAfdeling
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TekstAfdeling;
    /**
     * The TekstContactPersoon
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TekstContactPersoon;
    /**
     * The TekstOrganisatie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TekstOrganisatie;
    /**
     * The TekstProcedure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TekstProcedure;
    /**
     * The TekstVacature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TekstVacature;
    /**
     * The TypeVacature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TypeVacature;
    /**
     * The VacatureCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $VacatureCode;
    /**
     * The VacatureNaamExtern
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $VacatureNaamExtern;
    /**
     * The _Actief
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $_Actief;
    /**
     * The _Ingediend
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $_Ingediend;
    /**
     * The Template
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Template;
    /**
     * The TekstCriteria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TekstCriteria;
    /**
     * The TekstProcedure_DatumSollicitatie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TekstProcedure_DatumSollicitatie;
    /**
     * The TekstDataGesprekken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TekstDataGesprekken;
    /**
     * The Vacature_SD_AantalJarenErvaring
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \web\StructType\Vacature_SD_AantalJarenErvaring
     */
    public $Vacature_SD_AantalJarenErvaring;
    /**
     * The Vacature_SD_Criteria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \web\StructType\Vacature_SD_Criteria
     */
    public $Vacature_SD_Criteria;
    /**
     * The Vacature_SD_Opleidingsniveau_Recruitement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \web\StructType\Vacature_SD_Opleidingsniveau_Recruitement
     */
    public $Vacature_SD_Opleidingsniveau_Recruitement;
    /**
     * The Vacature_SD_Wervingskanaal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \web\StructType\Vacature_SD_Wervingskanaal
     */
    public $Vacature_SD_Wervingskanaal;
    /**
     * The Vacature_SD_Functie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \web\StructType\Vacature_SD_Functie
     */
    public $Vacature_SD_Functie;
    /**
     * The Vacature_SD_Afdeling
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \web\StructType\Vacature_SD_Afdeling
     */
    public $Vacature_SD_Afdeling;
    /**
     * The Vacature_SD_SoortContract
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \web\StructType\Vacature_SD_SoortContract
     */
    public $Vacature_SD_SoortContract;
    /**
     * The Vacature_SD_Kenmerk1
     * @var \web\StructType\Vacature_SD_Kenmerk1
     */
    public $Vacature_SD_Kenmerk1;
    /**
     * The Vacature_SD_Kenmerk2
     * @var \web\StructType\Vacature_SD_Kenmerk2
     */
    public $Vacature_SD_Kenmerk2;
    /**
     * The URL_Vacture
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $URL_Vacture;
    /**
     * The URL_Sollicitatieformulier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $URL_Sollicitatieformulier;
    /**
     * The RandomHash_Sollicitatieformulier
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $RandomHash_Sollicitatieformulier;
    /**
     * Constructor method for OpenstaandeVacatures_Extern
     * @uses OpenstaandeVacatures_Extern::setAantalFte()
     * @uses OpenstaandeVacatures_Extern::setAantalUren()
     * @uses OpenstaandeVacatures_Extern::setDatumStartPublicatieIntern()
     * @uses OpenstaandeVacatures_Extern::setDatumEindePublicatieIntern()
     * @uses OpenstaandeVacatures_Extern::setDatumInvulling()
     * @uses OpenstaandeVacatures_Extern::setDatumStartPublicatieExtern()
     * @uses OpenstaandeVacatures_Extern::setDatumEindePublicatieExtern()
     * @uses OpenstaandeVacatures_Extern::setDatumStartVacature()
     * @uses OpenstaandeVacatures_Extern::setDatumEindeVacature()
     * @uses OpenstaandeVacatures_Extern::setDuur()
     * @uses OpenstaandeVacatures_Extern::setDuur_Dienstverband()
     * @uses OpenstaandeVacatures_Extern::setNaam()
     * @uses OpenstaandeVacatures_Extern::setNummer()
     * @uses OpenstaandeVacatures_Extern::setStatus()
     * @uses OpenstaandeVacatures_Extern::setStandplaats()
     * @uses OpenstaandeVacatures_Extern::setTeaser()
     * @uses OpenstaandeVacatures_Extern::setTekstArbeidsvoorwaarden()
     * @uses OpenstaandeVacatures_Extern::setTekstAfdeling()
     * @uses OpenstaandeVacatures_Extern::setTekstContactPersoon()
     * @uses OpenstaandeVacatures_Extern::setTekstOrganisatie()
     * @uses OpenstaandeVacatures_Extern::setTekstProcedure()
     * @uses OpenstaandeVacatures_Extern::setTekstVacature()
     * @uses OpenstaandeVacatures_Extern::setTypeVacature()
     * @uses OpenstaandeVacatures_Extern::setVacatureCode()
     * @uses OpenstaandeVacatures_Extern::setVacatureNaamExtern()
     * @uses OpenstaandeVacatures_Extern::set_Actief()
     * @uses OpenstaandeVacatures_Extern::set_Ingediend()
     * @uses OpenstaandeVacatures_Extern::setTemplate()
     * @uses OpenstaandeVacatures_Extern::setTekstCriteria()
     * @uses OpenstaandeVacatures_Extern::setTekstProcedure_DatumSollicitatie()
     * @uses OpenstaandeVacatures_Extern::setTekstDataGesprekken()
     * @uses OpenstaandeVacatures_Extern::setVacature_SD_AantalJarenErvaring()
     * @uses OpenstaandeVacatures_Extern::setVacature_SD_Criteria()
     * @uses OpenstaandeVacatures_Extern::setVacature_SD_Opleidingsniveau_Recruitement()
     * @uses OpenstaandeVacatures_Extern::setVacature_SD_Wervingskanaal()
     * @uses OpenstaandeVacatures_Extern::setVacature_SD_Functie()
     * @uses OpenstaandeVacatures_Extern::setVacature_SD_Afdeling()
     * @uses OpenstaandeVacatures_Extern::setVacature_SD_SoortContract()
     * @uses OpenstaandeVacatures_Extern::setVacature_SD_Kenmerk1()
     * @uses OpenstaandeVacatures_Extern::setVacature_SD_Kenmerk2()
     * @uses OpenstaandeVacatures_Extern::setURL_Vacture()
     * @uses OpenstaandeVacatures_Extern::setURL_Sollicitatieformulier()
     * @uses OpenstaandeVacatures_Extern::setRandomHash_Sollicitatieformulier()
     * @param float $aantalFte
     * @param float $aantalUren
     * @param string $datumStartPublicatieIntern
     * @param string $datumEindePublicatieIntern
     * @param string $datumInvulling
     * @param string $datumStartPublicatieExtern
     * @param string $datumEindePublicatieExtern
     * @param string $datumStartVacature
     * @param string $datumEindeVacature
     * @param float $duur
     * @param float $duur_Dienstverband
     * @param string $naam
     * @param int $nummer
     * @param string $status
     * @param string $standplaats
     * @param string $teaser
     * @param string $tekstArbeidsvoorwaarden
     * @param string $tekstAfdeling
     * @param string $tekstContactPersoon
     * @param string $tekstOrganisatie
     * @param string $tekstProcedure
     * @param string $tekstVacature
     * @param string $typeVacature
     * @param string $vacatureCode
     * @param string $vacatureNaamExtern
     * @param bool $_Actief
     * @param bool $_Ingediend
     * @param string $template
     * @param string $tekstCriteria
     * @param string $tekstProcedure_DatumSollicitatie
     * @param string $tekstDataGesprekken
     * @param \web\StructType\Vacature_SD_AantalJarenErvaring $vacature_SD_AantalJarenErvaring
     * @param \web\StructType\Vacature_SD_Criteria $vacature_SD_Criteria
     * @param \web\StructType\Vacature_SD_Opleidingsniveau_Recruitement $vacature_SD_Opleidingsniveau_Recruitement
     * @param \web\StructType\Vacature_SD_Wervingskanaal $vacature_SD_Wervingskanaal
     * @param \web\StructType\Vacature_SD_Functie $vacature_SD_Functie
     * @param \web\StructType\Vacature_SD_Afdeling $vacature_SD_Afdeling
     * @param \web\StructType\Vacature_SD_SoortContract $vacature_SD_SoortContract
     * @param \web\StructType\Vacature_SD_Kenmerk1 $vacature_SD_Kenmerk1
     * @param \web\StructType\Vacature_SD_Kenmerk2 $vacature_SD_Kenmerk2
     * @param string $uRL_Vacture
     * @param string $uRL_Sollicitatieformulier
     * @param string $randomHash_Sollicitatieformulier
     */
    public function __construct($aantalFte = null, $aantalUren = null, $datumStartPublicatieIntern = null, $datumEindePublicatieIntern = null, $datumInvulling = null, $datumStartPublicatieExtern = null, $datumEindePublicatieExtern = null, $datumStartVacature = null, $datumEindeVacature = null, $duur = null, $duur_Dienstverband = null, $naam = null, $nummer = null, $status = null, $standplaats = null, $teaser = null, $tekstArbeidsvoorwaarden = null, $tekstAfdeling = null, $tekstContactPersoon = null, $tekstOrganisatie = null, $tekstProcedure = null, $tekstVacature = null, $typeVacature = null, $vacatureCode = null, $vacatureNaamExtern = null, $_Actief = null, $_Ingediend = null, $template = null, $tekstCriteria = null, $tekstProcedure_DatumSollicitatie = null, $tekstDataGesprekken = null, \web\StructType\Vacature_SD_AantalJarenErvaring $vacature_SD_AantalJarenErvaring = null, \web\StructType\Vacature_SD_Criteria $vacature_SD_Criteria = null, \web\StructType\Vacature_SD_Opleidingsniveau_Recruitement $vacature_SD_Opleidingsniveau_Recruitement = null, \web\StructType\Vacature_SD_Wervingskanaal $vacature_SD_Wervingskanaal = null, \web\StructType\Vacature_SD_Functie $vacature_SD_Functie = null, \web\StructType\Vacature_SD_Afdeling $vacature_SD_Afdeling = null, \web\StructType\Vacature_SD_SoortContract $vacature_SD_SoortContract = null, \web\StructType\Vacature_SD_Kenmerk1 $vacature_SD_Kenmerk1 = null, \web\StructType\Vacature_SD_Kenmerk2 $vacature_SD_Kenmerk2 = null, $uRL_Vacture = null, $uRL_Sollicitatieformulier = null, $randomHash_Sollicitatieformulier = null)
    {
        $this
            ->setAantalFte($aantalFte)
            ->setAantalUren($aantalUren)
            ->setDatumStartPublicatieIntern($datumStartPublicatieIntern)
            ->setDatumEindePublicatieIntern($datumEindePublicatieIntern)
            ->setDatumInvulling($datumInvulling)
            ->setDatumStartPublicatieExtern($datumStartPublicatieExtern)
            ->setDatumEindePublicatieExtern($datumEindePublicatieExtern)
            ->setDatumStartVacature($datumStartVacature)
            ->setDatumEindeVacature($datumEindeVacature)
            ->setDuur($duur)
            ->setDuur_Dienstverband($duur_Dienstverband)
            ->setNaam($naam)
            ->setNummer($nummer)
            ->setStatus($status)
            ->setStandplaats($standplaats)
            ->setTeaser($teaser)
            ->setTekstArbeidsvoorwaarden($tekstArbeidsvoorwaarden)
            ->setTekstAfdeling($tekstAfdeling)
            ->setTekstContactPersoon($tekstContactPersoon)
            ->setTekstOrganisatie($tekstOrganisatie)
            ->setTekstProcedure($tekstProcedure)
            ->setTekstVacature($tekstVacature)
            ->setTypeVacature($typeVacature)
            ->setVacatureCode($vacatureCode)
            ->setVacatureNaamExtern($vacatureNaamExtern)
            ->set_Actief($_Actief)
            ->set_Ingediend($_Ingediend)
            ->setTemplate($template)
            ->setTekstCriteria($tekstCriteria)
            ->setTekstProcedure_DatumSollicitatie($tekstProcedure_DatumSollicitatie)
            ->setTekstDataGesprekken($tekstDataGesprekken)
            ->setVacature_SD_AantalJarenErvaring($vacature_SD_AantalJarenErvaring)
            ->setVacature_SD_Criteria($vacature_SD_Criteria)
            ->setVacature_SD_Opleidingsniveau_Recruitement($vacature_SD_Opleidingsniveau_Recruitement)
            ->setVacature_SD_Wervingskanaal($vacature_SD_Wervingskanaal)
            ->setVacature_SD_Functie($vacature_SD_Functie)
            ->setVacature_SD_Afdeling($vacature_SD_Afdeling)
            ->setVacature_SD_SoortContract($vacature_SD_SoortContract)
            ->setVacature_SD_Kenmerk1($vacature_SD_Kenmerk1)
            ->setVacature_SD_Kenmerk2($vacature_SD_Kenmerk2)
            ->setURL_Vacture($uRL_Vacture)
            ->setURL_Sollicitatieformulier($uRL_Sollicitatieformulier)
            ->setRandomHash_Sollicitatieformulier($randomHash_Sollicitatieformulier);
    }
    /**
     * Get AantalFte value
     * @return float|null
     */
    public function getAantalFte()
    {
        return $this->AantalFte;
    }
    /**
     * Set AantalFte value
     * @param float $aantalFte
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setAantalFte($aantalFte = null)
    {
        $this->AantalFte = $aantalFte;
        return $this;
    }
    /**
     * Get AantalUren value
     * @return float|null
     */
    public function getAantalUren()
    {
        return $this->AantalUren;
    }
    /**
     * Set AantalUren value
     * @param float $aantalUren
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setAantalUren($aantalUren = null)
    {
        $this->AantalUren = $aantalUren;
        return $this;
    }
    /**
     * Get DatumStartPublicatieIntern value
     * @return string|null
     */
    public function getDatumStartPublicatieIntern()
    {
        return $this->DatumStartPublicatieIntern;
    }
    /**
     * Set DatumStartPublicatieIntern value
     * @param string $datumStartPublicatieIntern
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setDatumStartPublicatieIntern($datumStartPublicatieIntern = null)
    {
        // validation for constraint: string
        if (!is_null($datumStartPublicatieIntern) && !is_string($datumStartPublicatieIntern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumStartPublicatieIntern)), __LINE__);
        }
        $this->DatumStartPublicatieIntern = $datumStartPublicatieIntern;
        return $this;
    }
    /**
     * Get DatumEindePublicatieIntern value
     * @return string|null
     */
    public function getDatumEindePublicatieIntern()
    {
        return $this->DatumEindePublicatieIntern;
    }
    /**
     * Set DatumEindePublicatieIntern value
     * @param string $datumEindePublicatieIntern
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setDatumEindePublicatieIntern($datumEindePublicatieIntern = null)
    {
        // validation for constraint: string
        if (!is_null($datumEindePublicatieIntern) && !is_string($datumEindePublicatieIntern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumEindePublicatieIntern)), __LINE__);
        }
        $this->DatumEindePublicatieIntern = $datumEindePublicatieIntern;
        return $this;
    }
    /**
     * Get DatumInvulling value
     * @return string|null
     */
    public function getDatumInvulling()
    {
        return $this->DatumInvulling;
    }
    /**
     * Set DatumInvulling value
     * @param string $datumInvulling
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setDatumInvulling($datumInvulling = null)
    {
        // validation for constraint: string
        if (!is_null($datumInvulling) && !is_string($datumInvulling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumInvulling)), __LINE__);
        }
        $this->DatumInvulling = $datumInvulling;
        return $this;
    }
    /**
     * Get DatumStartPublicatieExtern value
     * @return string|null
     */
    public function getDatumStartPublicatieExtern()
    {
        return $this->DatumStartPublicatieExtern;
    }
    /**
     * Set DatumStartPublicatieExtern value
     * @param string $datumStartPublicatieExtern
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setDatumStartPublicatieExtern($datumStartPublicatieExtern = null)
    {
        // validation for constraint: string
        if (!is_null($datumStartPublicatieExtern) && !is_string($datumStartPublicatieExtern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumStartPublicatieExtern)), __LINE__);
        }
        $this->DatumStartPublicatieExtern = $datumStartPublicatieExtern;
        return $this;
    }
    /**
     * Get DatumEindePublicatieExtern value
     * @return string|null
     */
    public function getDatumEindePublicatieExtern()
    {
        return $this->DatumEindePublicatieExtern;
    }
    /**
     * Set DatumEindePublicatieExtern value
     * @param string $datumEindePublicatieExtern
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setDatumEindePublicatieExtern($datumEindePublicatieExtern = null)
    {
        // validation for constraint: string
        if (!is_null($datumEindePublicatieExtern) && !is_string($datumEindePublicatieExtern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumEindePublicatieExtern)), __LINE__);
        }
        $this->DatumEindePublicatieExtern = $datumEindePublicatieExtern;
        return $this;
    }
    /**
     * Get DatumStartVacature value
     * @return string|null
     */
    public function getDatumStartVacature()
    {
        return $this->DatumStartVacature;
    }
    /**
     * Set DatumStartVacature value
     * @param string $datumStartVacature
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setDatumStartVacature($datumStartVacature = null)
    {
        // validation for constraint: string
        if (!is_null($datumStartVacature) && !is_string($datumStartVacature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumStartVacature)), __LINE__);
        }
        $this->DatumStartVacature = $datumStartVacature;
        return $this;
    }
    /**
     * Get DatumEindeVacature value
     * @return string|null
     */
    public function getDatumEindeVacature()
    {
        return $this->DatumEindeVacature;
    }
    /**
     * Set DatumEindeVacature value
     * @param string $datumEindeVacature
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setDatumEindeVacature($datumEindeVacature = null)
    {
        // validation for constraint: string
        if (!is_null($datumEindeVacature) && !is_string($datumEindeVacature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumEindeVacature)), __LINE__);
        }
        $this->DatumEindeVacature = $datumEindeVacature;
        return $this;
    }
    /**
     * Get Duur value
     * @return float|null
     */
    public function getDuur()
    {
        return $this->Duur;
    }
    /**
     * Set Duur value
     * @param float $duur
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setDuur($duur = null)
    {
        $this->Duur = $duur;
        return $this;
    }
    /**
     * Get Duur_Dienstverband value
     * @return float|null
     */
    public function getDuur_Dienstverband()
    {
        return $this->Duur_Dienstverband;
    }
    /**
     * Set Duur_Dienstverband value
     * @param float $duur_Dienstverband
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setDuur_Dienstverband($duur_Dienstverband = null)
    {
        $this->Duur_Dienstverband = $duur_Dienstverband;
        return $this;
    }
    /**
     * Get Naam value
     * @return string|null
     */
    public function getNaam()
    {
        return $this->Naam;
    }
    /**
     * Set Naam value
     * @param string $naam
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setNaam($naam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($naam) && strlen($naam) > 200) || (is_array($naam) && count($naam) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($naam) ? strlen($naam) : count($naam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($naam) && !is_string($naam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naam)), __LINE__);
        }
        $this->Naam = $naam;
        return $this;
    }
    /**
     * Get Nummer value
     * @return int|null
     */
    public function getNummer()
    {
        return $this->Nummer;
    }
    /**
     * Set Nummer value
     * @param int $nummer
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setNummer($nummer = null)
    {
        // validation for constraint: int
        if (!is_null($nummer) && !is_numeric($nummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nummer)), __LINE__);
        }
        $this->Nummer = $nummer;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \web\EnumType\Status::valueIsValid()
     * @uses \web\EnumType\Status::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\web\EnumType\Status::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \web\EnumType\Status::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Standplaats value
     * @return string|null
     */
    public function getStandplaats()
    {
        return $this->Standplaats;
    }
    /**
     * Set Standplaats value
     * @param string $standplaats
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setStandplaats($standplaats = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($standplaats) && strlen($standplaats) > 200) || (is_array($standplaats) && count($standplaats) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($standplaats) ? strlen($standplaats) : count($standplaats)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($standplaats) && !is_string($standplaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($standplaats)), __LINE__);
        }
        $this->Standplaats = $standplaats;
        return $this;
    }
    /**
     * Get Teaser value
     * @return string|null
     */
    public function getTeaser()
    {
        return $this->Teaser;
    }
    /**
     * Set Teaser value
     * @param string $teaser
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTeaser($teaser = null)
    {
        // validation for constraint: string
        if (!is_null($teaser) && !is_string($teaser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($teaser)), __LINE__);
        }
        $this->Teaser = $teaser;
        return $this;
    }
    /**
     * Get TekstArbeidsvoorwaarden value
     * @return string|null
     */
    public function getTekstArbeidsvoorwaarden()
    {
        return $this->TekstArbeidsvoorwaarden;
    }
    /**
     * Set TekstArbeidsvoorwaarden value
     * @param string $tekstArbeidsvoorwaarden
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTekstArbeidsvoorwaarden($tekstArbeidsvoorwaarden = null)
    {
        // validation for constraint: string
        if (!is_null($tekstArbeidsvoorwaarden) && !is_string($tekstArbeidsvoorwaarden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tekstArbeidsvoorwaarden)), __LINE__);
        }
        $this->TekstArbeidsvoorwaarden = $tekstArbeidsvoorwaarden;
        return $this;
    }
    /**
     * Get TekstAfdeling value
     * @return string|null
     */
    public function getTekstAfdeling()
    {
        return $this->TekstAfdeling;
    }
    /**
     * Set TekstAfdeling value
     * @param string $tekstAfdeling
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTekstAfdeling($tekstAfdeling = null)
    {
        // validation for constraint: string
        if (!is_null($tekstAfdeling) && !is_string($tekstAfdeling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tekstAfdeling)), __LINE__);
        }
        $this->TekstAfdeling = $tekstAfdeling;
        return $this;
    }
    /**
     * Get TekstContactPersoon value
     * @return string|null
     */
    public function getTekstContactPersoon()
    {
        return $this->TekstContactPersoon;
    }
    /**
     * Set TekstContactPersoon value
     * @param string $tekstContactPersoon
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTekstContactPersoon($tekstContactPersoon = null)
    {
        // validation for constraint: string
        if (!is_null($tekstContactPersoon) && !is_string($tekstContactPersoon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tekstContactPersoon)), __LINE__);
        }
        $this->TekstContactPersoon = $tekstContactPersoon;
        return $this;
    }
    /**
     * Get TekstOrganisatie value
     * @return string|null
     */
    public function getTekstOrganisatie()
    {
        return $this->TekstOrganisatie;
    }
    /**
     * Set TekstOrganisatie value
     * @param string $tekstOrganisatie
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTekstOrganisatie($tekstOrganisatie = null)
    {
        // validation for constraint: string
        if (!is_null($tekstOrganisatie) && !is_string($tekstOrganisatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tekstOrganisatie)), __LINE__);
        }
        $this->TekstOrganisatie = $tekstOrganisatie;
        return $this;
    }
    /**
     * Get TekstProcedure value
     * @return string|null
     */
    public function getTekstProcedure()
    {
        return $this->TekstProcedure;
    }
    /**
     * Set TekstProcedure value
     * @param string $tekstProcedure
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTekstProcedure($tekstProcedure = null)
    {
        // validation for constraint: string
        if (!is_null($tekstProcedure) && !is_string($tekstProcedure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tekstProcedure)), __LINE__);
        }
        $this->TekstProcedure = $tekstProcedure;
        return $this;
    }
    /**
     * Get TekstVacature value
     * @return string|null
     */
    public function getTekstVacature()
    {
        return $this->TekstVacature;
    }
    /**
     * Set TekstVacature value
     * @param string $tekstVacature
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTekstVacature($tekstVacature = null)
    {
        // validation for constraint: string
        if (!is_null($tekstVacature) && !is_string($tekstVacature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tekstVacature)), __LINE__);
        }
        $this->TekstVacature = $tekstVacature;
        return $this;
    }
    /**
     * Get TypeVacature value
     * @return string|null
     */
    public function getTypeVacature()
    {
        return $this->TypeVacature;
    }
    /**
     * Set TypeVacature value
     * @uses \web\EnumType\TypeVacature::valueIsValid()
     * @uses \web\EnumType\TypeVacature::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeVacature
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTypeVacature($typeVacature = null)
    {
        // validation for constraint: enumeration
        if (!\web\EnumType\TypeVacature::valueIsValid($typeVacature)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $typeVacature, implode(', ', \web\EnumType\TypeVacature::getValidValues())), __LINE__);
        }
        $this->TypeVacature = $typeVacature;
        return $this;
    }
    /**
     * Get VacatureCode value
     * @return string|null
     */
    public function getVacatureCode()
    {
        return $this->VacatureCode;
    }
    /**
     * Set VacatureCode value
     * @param string $vacatureCode
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacatureCode($vacatureCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vacatureCode) && strlen($vacatureCode) > 50) || (is_array($vacatureCode) && count($vacatureCode) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($vacatureCode) ? strlen($vacatureCode) : count($vacatureCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vacatureCode) && !is_string($vacatureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vacatureCode)), __LINE__);
        }
        $this->VacatureCode = $vacatureCode;
        return $this;
    }
    /**
     * Get VacatureNaamExtern value
     * @return string|null
     */
    public function getVacatureNaamExtern()
    {
        return $this->VacatureNaamExtern;
    }
    /**
     * Set VacatureNaamExtern value
     * @param string $vacatureNaamExtern
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacatureNaamExtern($vacatureNaamExtern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vacatureNaamExtern) && strlen($vacatureNaamExtern) > 200) || (is_array($vacatureNaamExtern) && count($vacatureNaamExtern) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($vacatureNaamExtern) ? strlen($vacatureNaamExtern) : count($vacatureNaamExtern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vacatureNaamExtern) && !is_string($vacatureNaamExtern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vacatureNaamExtern)), __LINE__);
        }
        $this->VacatureNaamExtern = $vacatureNaamExtern;
        return $this;
    }
    /**
     * Get _Actief value
     * @return bool|null
     */
    public function get_Actief()
    {
        return $this->_Actief;
    }
    /**
     * Set _Actief value
     * @param bool $_Actief
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function set_Actief($_Actief = null)
    {
        // validation for constraint: boolean
        if (!is_null($_Actief) && !is_bool($_Actief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($_Actief)), __LINE__);
        }
        $this->_Actief = $_Actief;
        return $this;
    }
    /**
     * Get _Ingediend value
     * @return bool|null
     */
    public function get_Ingediend()
    {
        return $this->_Ingediend;
    }
    /**
     * Set _Ingediend value
     * @param bool $_Ingediend
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function set_Ingediend($_Ingediend = null)
    {
        // validation for constraint: boolean
        if (!is_null($_Ingediend) && !is_bool($_Ingediend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($_Ingediend)), __LINE__);
        }
        $this->_Ingediend = $_Ingediend;
        return $this;
    }
    /**
     * Get Template value
     * @return string|null
     */
    public function getTemplate()
    {
        return $this->Template;
    }
    /**
     * Set Template value
     * @uses \web\EnumType\Template::valueIsValid()
     * @uses \web\EnumType\Template::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $template
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTemplate($template = null)
    {
        // validation for constraint: enumeration
        if (!\web\EnumType\Template::valueIsValid($template)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $template, implode(', ', \web\EnumType\Template::getValidValues())), __LINE__);
        }
        $this->Template = $template;
        return $this;
    }
    /**
     * Get TekstCriteria value
     * @return string|null
     */
    public function getTekstCriteria()
    {
        return $this->TekstCriteria;
    }
    /**
     * Set TekstCriteria value
     * @param string $tekstCriteria
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTekstCriteria($tekstCriteria = null)
    {
        // validation for constraint: string
        if (!is_null($tekstCriteria) && !is_string($tekstCriteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tekstCriteria)), __LINE__);
        }
        $this->TekstCriteria = $tekstCriteria;
        return $this;
    }
    /**
     * Get TekstProcedure_DatumSollicitatie value
     * @return string|null
     */
    public function getTekstProcedure_DatumSollicitatie()
    {
        return $this->TekstProcedure_DatumSollicitatie;
    }
    /**
     * Set TekstProcedure_DatumSollicitatie value
     * @param string $tekstProcedure_DatumSollicitatie
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTekstProcedure_DatumSollicitatie($tekstProcedure_DatumSollicitatie = null)
    {
        // validation for constraint: string
        if (!is_null($tekstProcedure_DatumSollicitatie) && !is_string($tekstProcedure_DatumSollicitatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tekstProcedure_DatumSollicitatie)), __LINE__);
        }
        $this->TekstProcedure_DatumSollicitatie = $tekstProcedure_DatumSollicitatie;
        return $this;
    }
    /**
     * Get TekstDataGesprekken value
     * @return string|null
     */
    public function getTekstDataGesprekken()
    {
        return $this->TekstDataGesprekken;
    }
    /**
     * Set TekstDataGesprekken value
     * @param string $tekstDataGesprekken
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setTekstDataGesprekken($tekstDataGesprekken = null)
    {
        // validation for constraint: string
        if (!is_null($tekstDataGesprekken) && !is_string($tekstDataGesprekken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tekstDataGesprekken)), __LINE__);
        }
        $this->TekstDataGesprekken = $tekstDataGesprekken;
        return $this;
    }
    /**
     * Get Vacature_SD_AantalJarenErvaring value
     * @return \web\StructType\Vacature_SD_AantalJarenErvaring|null
     */
    public function getVacature_SD_AantalJarenErvaring()
    {
        return $this->Vacature_SD_AantalJarenErvaring;
    }
    /**
     * Set Vacature_SD_AantalJarenErvaring value
     * @param \web\StructType\Vacature_SD_AantalJarenErvaring $vacature_SD_AantalJarenErvaring
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacature_SD_AantalJarenErvaring(\web\StructType\Vacature_SD_AantalJarenErvaring $vacature_SD_AantalJarenErvaring = null)
    {
        $this->Vacature_SD_AantalJarenErvaring = $vacature_SD_AantalJarenErvaring;
        return $this;
    }
    /**
     * Get Vacature_SD_Criteria value
     * @return \web\StructType\Vacature_SD_Criteria|null
     */
    public function getVacature_SD_Criteria()
    {
        return $this->Vacature_SD_Criteria;
    }
    /**
     * Set Vacature_SD_Criteria value
     * @param \web\StructType\Vacature_SD_Criteria $vacature_SD_Criteria
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacature_SD_Criteria(\web\StructType\Vacature_SD_Criteria $vacature_SD_Criteria = null)
    {
        $this->Vacature_SD_Criteria = $vacature_SD_Criteria;
        return $this;
    }
    /**
     * Get Vacature_SD_Opleidingsniveau_Recruitement value
     * @return \web\StructType\Vacature_SD_Opleidingsniveau_Recruitement|null
     */
    public function getVacature_SD_Opleidingsniveau_Recruitement()
    {
        return $this->Vacature_SD_Opleidingsniveau_Recruitement;
    }
    /**
     * Set Vacature_SD_Opleidingsniveau_Recruitement value
     * @param \web\StructType\Vacature_SD_Opleidingsniveau_Recruitement $vacature_SD_Opleidingsniveau_Recruitement
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacature_SD_Opleidingsniveau_Recruitement(\web\StructType\Vacature_SD_Opleidingsniveau_Recruitement $vacature_SD_Opleidingsniveau_Recruitement = null)
    {
        $this->Vacature_SD_Opleidingsniveau_Recruitement = $vacature_SD_Opleidingsniveau_Recruitement;
        return $this;
    }
    /**
     * Get Vacature_SD_Wervingskanaal value
     * @return \web\StructType\Vacature_SD_Wervingskanaal|null
     */
    public function getVacature_SD_Wervingskanaal()
    {
        return $this->Vacature_SD_Wervingskanaal;
    }
    /**
     * Set Vacature_SD_Wervingskanaal value
     * @param \web\StructType\Vacature_SD_Wervingskanaal $vacature_SD_Wervingskanaal
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacature_SD_Wervingskanaal(\web\StructType\Vacature_SD_Wervingskanaal $vacature_SD_Wervingskanaal = null)
    {
        $this->Vacature_SD_Wervingskanaal = $vacature_SD_Wervingskanaal;
        return $this;
    }
    /**
     * Get Vacature_SD_Functie value
     * @return \web\StructType\Vacature_SD_Functie|null
     */
    public function getVacature_SD_Functie()
    {
        return $this->Vacature_SD_Functie;
    }
    /**
     * Set Vacature_SD_Functie value
     * @param \web\StructType\Vacature_SD_Functie $vacature_SD_Functie
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacature_SD_Functie(\web\StructType\Vacature_SD_Functie $vacature_SD_Functie = null)
    {
        $this->Vacature_SD_Functie = $vacature_SD_Functie;
        return $this;
    }
    /**
     * Get Vacature_SD_Afdeling value
     * @return \web\StructType\Vacature_SD_Afdeling|null
     */
    public function getVacature_SD_Afdeling()
    {
        return $this->Vacature_SD_Afdeling;
    }
    /**
     * Set Vacature_SD_Afdeling value
     * @param \web\StructType\Vacature_SD_Afdeling $vacature_SD_Afdeling
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacature_SD_Afdeling(\web\StructType\Vacature_SD_Afdeling $vacature_SD_Afdeling = null)
    {
        $this->Vacature_SD_Afdeling = $vacature_SD_Afdeling;
        return $this;
    }
    /**
     * Get Vacature_SD_SoortContract value
     * @return \web\StructType\Vacature_SD_SoortContract|null
     */
    public function getVacature_SD_SoortContract()
    {
        return $this->Vacature_SD_SoortContract;
    }
    /**
     * Set Vacature_SD_SoortContract value
     * @param \web\StructType\Vacature_SD_SoortContract $vacature_SD_SoortContract
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacature_SD_SoortContract(\web\StructType\Vacature_SD_SoortContract $vacature_SD_SoortContract = null)
    {
        $this->Vacature_SD_SoortContract = $vacature_SD_SoortContract;
        return $this;
    }
    /**
     * Get Vacature_SD_Kenmerk1 value
     * @return \web\StructType\Vacature_SD_Kenmerk1|null
     */
    public function getVacature_SD_Kenmerk1()
    {
        return $this->Vacature_SD_Kenmerk1;
    }
    /**
     * Set Vacature_SD_Kenmerk1 value
     * @param \web\StructType\Vacature_SD_Kenmerk1 $vacature_SD_Kenmerk1
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacature_SD_Kenmerk1(\web\StructType\Vacature_SD_Kenmerk1 $vacature_SD_Kenmerk1 = null)
    {
        $this->Vacature_SD_Kenmerk1 = $vacature_SD_Kenmerk1;
        return $this;
    }
    /**
     * Get Vacature_SD_Kenmerk2 value
     * @return \web\StructType\Vacature_SD_Kenmerk2|null
     */
    public function getVacature_SD_Kenmerk2()
    {
        return $this->Vacature_SD_Kenmerk2;
    }
    /**
     * Set Vacature_SD_Kenmerk2 value
     * @param \web\StructType\Vacature_SD_Kenmerk2 $vacature_SD_Kenmerk2
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setVacature_SD_Kenmerk2(\web\StructType\Vacature_SD_Kenmerk2 $vacature_SD_Kenmerk2 = null)
    {
        $this->Vacature_SD_Kenmerk2 = $vacature_SD_Kenmerk2;
        return $this;
    }
    /**
     * Get URL_Vacture value
     * @return string|null
     */
    public function getURL_Vacture()
    {
        return $this->URL_Vacture;
    }
    /**
     * Set URL_Vacture value
     * @param string $uRL_Vacture
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setURL_Vacture($uRL_Vacture = null)
    {
        // validation for constraint: string
        if (!is_null($uRL_Vacture) && !is_string($uRL_Vacture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL_Vacture)), __LINE__);
        }
        $this->URL_Vacture = $uRL_Vacture;
        return $this;
    }
    /**
     * Get URL_Sollicitatieformulier value
     * @return string|null
     */
    public function getURL_Sollicitatieformulier()
    {
        return $this->URL_Sollicitatieformulier;
    }
    /**
     * Set URL_Sollicitatieformulier value
     * @param string $uRL_Sollicitatieformulier
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setURL_Sollicitatieformulier($uRL_Sollicitatieformulier = null)
    {
        // validation for constraint: string
        if (!is_null($uRL_Sollicitatieformulier) && !is_string($uRL_Sollicitatieformulier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL_Sollicitatieformulier)), __LINE__);
        }
        $this->URL_Sollicitatieformulier = $uRL_Sollicitatieformulier;
        return $this;
    }
    /**
     * Get RandomHash_Sollicitatieformulier value
     * @return string|null
     */
    public function getRandomHash_Sollicitatieformulier()
    {
        return $this->RandomHash_Sollicitatieformulier;
    }
    /**
     * Set RandomHash_Sollicitatieformulier value
     * @param string $randomHash_Sollicitatieformulier
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public function setRandomHash_Sollicitatieformulier($randomHash_Sollicitatieformulier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($randomHash_Sollicitatieformulier) && strlen($randomHash_Sollicitatieformulier) > 200) || (is_array($randomHash_Sollicitatieformulier) && count($randomHash_Sollicitatieformulier) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($randomHash_Sollicitatieformulier) ? strlen($randomHash_Sollicitatieformulier) : count($randomHash_Sollicitatieformulier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($randomHash_Sollicitatieformulier) && !is_string($randomHash_Sollicitatieformulier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($randomHash_Sollicitatieformulier)), __LINE__);
        }
        $this->RandomHash_Sollicitatieformulier = $randomHash_Sollicitatieformulier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \web\StructType\OpenstaandeVacatures_Extern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
