<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://daywize-test.mendixcloud.com/ws-doc/Published_web_service_OpenVacatures?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://daywize-test.mendixcloud.com/ws-doc/Published_web_service_OpenVacatures?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \web\ClassMap::get(),
);
/**
 * Samples for Openstaande ServiceType
 */
$openstaande = new \web\ServiceType\Openstaande($options);
$openstaande->setSoapHeaderAuthentication(new \web\StructType\Authentication());
/**
 * Sample call for OpenstaandeVacatures_Extern operation/method
 */
if ($openstaande->OpenstaandeVacatures_Extern(new \web\StructType\OpenstaandeVacatures_Extern()) !== false) {
    print_r($openstaande->getResult());
} else {
    print_r($openstaande->getLastError());
}
/**
 * Sample call for OpenstaandeVacatures_Intern operation/method
 */
if ($openstaande->OpenstaandeVacatures_Intern(new \web\StructType\OpenstaandeVacatures_Intern()) !== false) {
    print_r($openstaande->getResult());
} else {
    print_r($openstaande->getLastError());
}
