<?php

namespace web\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SD_Wervingskanaal StructType
 * @subpackage Structs
 */
class SD_Wervingskanaal extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * The Omschrijving
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $Omschrijving;
    /**
     * Constructor method for SD_Wervingskanaal
     * @uses SD_Wervingskanaal::setCode()
     * @uses SD_Wervingskanaal::setOmschrijving()
     * @param int $code
     * @param string $omschrijving
     */
    public function __construct($code = null, $omschrijving = null)
    {
        $this
            ->setCode($code)
            ->setOmschrijving($omschrijving);
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \web\StructType\SD_Wervingskanaal
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Omschrijving value
     * @return string|null
     */
    public function getOmschrijving()
    {
        return $this->Omschrijving;
    }
    /**
     * Set Omschrijving value
     * @param string $omschrijving
     * @return \web\StructType\SD_Wervingskanaal
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($omschrijving) && strlen($omschrijving) > 200) || (is_array($omschrijving) && count($omschrijving) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($omschrijving) ? strlen($omschrijving) : count($omschrijving)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($omschrijving)), __LINE__);
        }
        $this->Omschrijving = $omschrijving;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \web\StructType\SD_Wervingskanaal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
