<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSessionStatus StructType
 * @subpackage Structs
 */
class UpdateSessionStatus extends AbstractStructBase
{
    /**
     * The CommunityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommunityId;
    /**
     * The SessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SessionId;
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $guid;
    /**
     * The StatusId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusId;
    /**
     * Constructor method for UpdateSessionStatus
     * @uses UpdateSessionStatus::setCommunityId()
     * @uses UpdateSessionStatus::setSessionId()
     * @uses UpdateSessionStatus::setGuid()
     * @uses UpdateSessionStatus::setStatusId()
     * @param int $communityId
     * @param int $sessionId
     * @param string $guid
     * @param string $statusId
     */
    public function __construct($communityId = null, $sessionId = null, $guid = null, $statusId = null)
    {
        $this
            ->setCommunityId($communityId)
            ->setSessionId($sessionId)
            ->setGuid($guid)
            ->setStatusId($statusId);
    }
    /**
     * Get CommunityId value
     * @return int
     */
    public function getCommunityId()
    {
        return $this->CommunityId;
    }
    /**
     * Set CommunityId value
     * @param int $communityId
     * @return \StructType\UpdateSessionStatus
     */
    public function setCommunityId($communityId = null)
    {
        // validation for constraint: int
        if (!is_null($communityId) && !is_numeric($communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($communityId)), __LINE__);
        }
        $this->CommunityId = $communityId;
        return $this;
    }
    /**
     * Get SessionId value
     * @return int
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param int $sessionId
     * @return \StructType\UpdateSessionStatus
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: int
        if (!is_null($sessionId) && !is_numeric($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\UpdateSessionStatus
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get StatusId value
     * @return string|null
     */
    public function getStatusId()
    {
        return $this->StatusId;
    }
    /**
     * Set StatusId value
     * @param string $statusId
     * @return \StructType\UpdateSessionStatus
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: string
        if (!is_null($statusId) && !is_string($statusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusId)), __LINE__);
        }
        $this->StatusId = $statusId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateSessionStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
