<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Compute ServiceType
 * @subpackage Services
 */
class Compute extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ComputeProcessTreeGrades
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComputeProcessTreeGrades $parameters
     * @return \StructType\ComputeProcessTreeGradesResponse|bool
     */
    public function ComputeProcessTreeGrades(\StructType\ComputeProcessTreeGrades $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ComputeProcessTreeGrades($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ComputeProcessTreeGradesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
