<?php

namespace EnumType;

/**
 * This class stands for ModeInscription EnumType
 * @subpackage Enumerations
 */
class ModeInscription
{
    /**
     * Constant for value 'Aucun'
     * @return string 'Aucun'
     */
    const VALUE_AUCUN = 'Aucun';
    /**
     * Constant for value 'inter'
     * @return string 'inter'
     */
    const VALUE_INTER = 'inter';
    /**
     * Constant for value 'intra'
     * @return string 'intra'
     */
    const VALUE_INTRA = 'intra';
    /**
     * Constant for value 'indiv'
     * @return string 'indiv'
     */
    const VALUE_INDIV = 'indiv';
    /**
     * Constant for value 'intrn'
     * @return string 'intrn'
     */
    const VALUE_INTRN = 'intrn';
    /**
     * Constant for value 'appre'
     * @return string 'appre'
     */
    const VALUE_APPRE = 'appre';
    /**
     * Constant for value 'nnter'
     * @return string 'nnter'
     */
    const VALUE_NNTER = 'nnter';
    /**
     * Constant for value 'nntra'
     * @return string 'nntra'
     */
    const VALUE_NNTRA = 'nntra';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUCUN
     * @uses self::VALUE_INTER
     * @uses self::VALUE_INTRA
     * @uses self::VALUE_INDIV
     * @uses self::VALUE_INTRN
     * @uses self::VALUE_APPRE
     * @uses self::VALUE_NNTER
     * @uses self::VALUE_NNTRA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUCUN,
            self::VALUE_INTER,
            self::VALUE_INTRA,
            self::VALUE_INDIV,
            self::VALUE_INTRN,
            self::VALUE_APPRE,
            self::VALUE_NNTER,
            self::VALUE_NNTRA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
