<?php

namespace EnumType;

/**
 * This class stands for EtatInscription EnumType
 * @subpackage Enumerations
 */
class EtatInscription
{
    /**
     * Constant for value 'NonValide'
     * @return string 'NonValide'
     */
    const VALUE_NON_VALIDE = 'NonValide';
    /**
     * Constant for value 'Valide'
     * @return string 'Valide'
     */
    const VALUE_VALIDE = 'Valide';
    /**
     * Constant for value 'Annule'
     * @return string 'Annule'
     */
    const VALUE_ANNULE = 'Annule';
    /**
     * Constant for value 'AnnuleProcess'
     * @return string 'AnnuleProcess'
     */
    const VALUE_ANNULE_PROCESS = 'AnnuleProcess';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NON_VALIDE
     * @uses self::VALUE_VALIDE
     * @uses self::VALUE_ANNULE
     * @uses self::VALUE_ANNULE_PROCESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NON_VALIDE,
            self::VALUE_VALIDE,
            self::VALUE_ANNULE,
            self::VALUE_ANNULE_PROCESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
