<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RepercussionResult StructType
 * @subpackage Structs
 */
class RepercussionResult extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The EventDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The SessionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionName;
    /**
     * The BatchName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BatchName;
    /**
     * The TraineeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TraineeName;
    /**
     * Constructor method for RepercussionResult
     * @uses RepercussionResult::setType()
     * @uses RepercussionResult::setEventDate()
     * @uses RepercussionResult::setSessionName()
     * @uses RepercussionResult::setBatchName()
     * @uses RepercussionResult::setTraineeName()
     * @param string $type
     * @param string $eventDate
     * @param string $sessionName
     * @param string $batchName
     * @param string $traineeName
     */
    public function __construct($type = null, $eventDate = null, $sessionName = null, $batchName = null, $traineeName = null)
    {
        $this
            ->setType($type)
            ->setEventDate($eventDate)
            ->setSessionName($sessionName)
            ->setBatchName($batchName)
            ->setTraineeName($traineeName);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ProcessRepercussionResult::valueIsValid()
     * @uses \EnumType\ProcessRepercussionResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\RepercussionResult
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProcessRepercussionResult::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ProcessRepercussionResult::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get EventDate value
     * @return string
     */
    public function getEventDate()
    {
        return $this->EventDate;
    }
    /**
     * Set EventDate value
     * @param string $eventDate
     * @return \StructType\RepercussionResult
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDate)), __LINE__);
        }
        $this->EventDate = $eventDate;
        return $this;
    }
    /**
     * Get SessionName value
     * @return string|null
     */
    public function getSessionName()
    {
        return $this->SessionName;
    }
    /**
     * Set SessionName value
     * @param string $sessionName
     * @return \StructType\RepercussionResult
     */
    public function setSessionName($sessionName = null)
    {
        // validation for constraint: string
        if (!is_null($sessionName) && !is_string($sessionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionName)), __LINE__);
        }
        $this->SessionName = $sessionName;
        return $this;
    }
    /**
     * Get BatchName value
     * @return string|null
     */
    public function getBatchName()
    {
        return $this->BatchName;
    }
    /**
     * Set BatchName value
     * @param string $batchName
     * @return \StructType\RepercussionResult
     */
    public function setBatchName($batchName = null)
    {
        // validation for constraint: string
        if (!is_null($batchName) && !is_string($batchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($batchName)), __LINE__);
        }
        $this->BatchName = $batchName;
        return $this;
    }
    /**
     * Get TraineeName value
     * @return string|null
     */
    public function getTraineeName()
    {
        return $this->TraineeName;
    }
    /**
     * Set TraineeName value
     * @param string $traineeName
     * @return \StructType\RepercussionResult
     */
    public function setTraineeName($traineeName = null)
    {
        // validation for constraint: string
        if (!is_null($traineeName) && !is_string($traineeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traineeName)), __LINE__);
        }
        $this->TraineeName = $traineeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RepercussionResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
