<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMarksByStudent StructType
 * @subpackage Structs
 */
class GetMarksByStudent extends AbstractStructBase
{
    /**
     * The communityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $communityId;
    /**
     * The studentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $studentId;
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $guid;
    /**
     * Constructor method for GetMarksByStudent
     * @uses GetMarksByStudent::setCommunityId()
     * @uses GetMarksByStudent::setStudentId()
     * @uses GetMarksByStudent::setGuid()
     * @param int $communityId
     * @param int $studentId
     * @param string $guid
     */
    public function __construct($communityId = null, $studentId = null, $guid = null)
    {
        $this
            ->setCommunityId($communityId)
            ->setStudentId($studentId)
            ->setGuid($guid);
    }
    /**
     * Get communityId value
     * @return int
     */
    public function getCommunityId()
    {
        return $this->communityId;
    }
    /**
     * Set communityId value
     * @param int $communityId
     * @return \StructType\GetMarksByStudent
     */
    public function setCommunityId($communityId = null)
    {
        // validation for constraint: int
        if (!is_null($communityId) && !is_numeric($communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($communityId)), __LINE__);
        }
        $this->communityId = $communityId;
        return $this;
    }
    /**
     * Get studentId value
     * @return int
     */
    public function getStudentId()
    {
        return $this->studentId;
    }
    /**
     * Set studentId value
     * @param int $studentId
     * @return \StructType\GetMarksByStudent
     */
    public function setStudentId($studentId = null)
    {
        // validation for constraint: int
        if (!is_null($studentId) && !is_numeric($studentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($studentId)), __LINE__);
        }
        $this->studentId = $studentId;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\GetMarksByStudent
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMarksByStudent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
