<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteGrade StructType
 * @subpackage Structs
 */
class DeleteGrade extends AbstractStructBase
{
    /**
     * The communityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $communityId;
    /**
     * The studentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $studentId;
    /**
     * The processId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $processId;
    /**
     * The evaluationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $evaluationId;
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $guid;
    /**
     * Constructor method for DeleteGrade
     * @uses DeleteGrade::setCommunityId()
     * @uses DeleteGrade::setStudentId()
     * @uses DeleteGrade::setProcessId()
     * @uses DeleteGrade::setEvaluationId()
     * @uses DeleteGrade::setGuid()
     * @param int $communityId
     * @param int $studentId
     * @param int $processId
     * @param int $evaluationId
     * @param string $guid
     */
    public function __construct($communityId = null, $studentId = null, $processId = null, $evaluationId = null, $guid = null)
    {
        $this
            ->setCommunityId($communityId)
            ->setStudentId($studentId)
            ->setProcessId($processId)
            ->setEvaluationId($evaluationId)
            ->setGuid($guid);
    }
    /**
     * Get communityId value
     * @return int
     */
    public function getCommunityId()
    {
        return $this->communityId;
    }
    /**
     * Set communityId value
     * @param int $communityId
     * @return \StructType\DeleteGrade
     */
    public function setCommunityId($communityId = null)
    {
        // validation for constraint: int
        if (!is_null($communityId) && !is_numeric($communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($communityId)), __LINE__);
        }
        $this->communityId = $communityId;
        return $this;
    }
    /**
     * Get studentId value
     * @return int
     */
    public function getStudentId()
    {
        return $this->studentId;
    }
    /**
     * Set studentId value
     * @param int $studentId
     * @return \StructType\DeleteGrade
     */
    public function setStudentId($studentId = null)
    {
        // validation for constraint: int
        if (!is_null($studentId) && !is_numeric($studentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($studentId)), __LINE__);
        }
        $this->studentId = $studentId;
        return $this;
    }
    /**
     * Get processId value
     * @return int
     */
    public function getProcessId()
    {
        return $this->processId;
    }
    /**
     * Set processId value
     * @param int $processId
     * @return \StructType\DeleteGrade
     */
    public function setProcessId($processId = null)
    {
        // validation for constraint: int
        if (!is_null($processId) && !is_numeric($processId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($processId)), __LINE__);
        }
        $this->processId = $processId;
        return $this;
    }
    /**
     * Get evaluationId value
     * @return int
     */
    public function getEvaluationId()
    {
        return $this->evaluationId;
    }
    /**
     * Set evaluationId value
     * @param int $evaluationId
     * @return \StructType\DeleteGrade
     */
    public function setEvaluationId($evaluationId = null)
    {
        // validation for constraint: int
        if (!is_null($evaluationId) && !is_numeric($evaluationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($evaluationId)), __LINE__);
        }
        $this->evaluationId = $evaluationId;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\DeleteGrade
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteGrade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
