<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreationResult StructType
 * @subpackage Structs
 */
class CreationResult extends AbstractStructBase
{
    /**
     * The NumberOfValidatedAbsences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfValidatedAbsences;
    /**
     * The NumberOfAbsencesCreated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfAbsencesCreated;
    /**
     * The HasError
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasError;
    /**
     * The AbsencesRejected
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAbsenceRejectedResult
     */
    public $AbsencesRejected;
    /**
     * The RepercussionErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRepercussionResult
     */
    public $RepercussionErrors;
    /**
     * Constructor method for CreationResult
     * @uses CreationResult::setNumberOfValidatedAbsences()
     * @uses CreationResult::setNumberOfAbsencesCreated()
     * @uses CreationResult::setHasError()
     * @uses CreationResult::setAbsencesRejected()
     * @uses CreationResult::setRepercussionErrors()
     * @param int $numberOfValidatedAbsences
     * @param int $numberOfAbsencesCreated
     * @param bool $hasError
     * @param \ArrayType\ArrayOfAbsenceRejectedResult $absencesRejected
     * @param \ArrayType\ArrayOfRepercussionResult $repercussionErrors
     */
    public function __construct($numberOfValidatedAbsences = null, $numberOfAbsencesCreated = null, $hasError = null, \ArrayType\ArrayOfAbsenceRejectedResult $absencesRejected = null, \ArrayType\ArrayOfRepercussionResult $repercussionErrors = null)
    {
        $this
            ->setNumberOfValidatedAbsences($numberOfValidatedAbsences)
            ->setNumberOfAbsencesCreated($numberOfAbsencesCreated)
            ->setHasError($hasError)
            ->setAbsencesRejected($absencesRejected)
            ->setRepercussionErrors($repercussionErrors);
    }
    /**
     * Get NumberOfValidatedAbsences value
     * @return int
     */
    public function getNumberOfValidatedAbsences()
    {
        return $this->NumberOfValidatedAbsences;
    }
    /**
     * Set NumberOfValidatedAbsences value
     * @param int $numberOfValidatedAbsences
     * @return \StructType\CreationResult
     */
    public function setNumberOfValidatedAbsences($numberOfValidatedAbsences = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfValidatedAbsences) && !is_numeric($numberOfValidatedAbsences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfValidatedAbsences)), __LINE__);
        }
        $this->NumberOfValidatedAbsences = $numberOfValidatedAbsences;
        return $this;
    }
    /**
     * Get NumberOfAbsencesCreated value
     * @return int
     */
    public function getNumberOfAbsencesCreated()
    {
        return $this->NumberOfAbsencesCreated;
    }
    /**
     * Set NumberOfAbsencesCreated value
     * @param int $numberOfAbsencesCreated
     * @return \StructType\CreationResult
     */
    public function setNumberOfAbsencesCreated($numberOfAbsencesCreated = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAbsencesCreated) && !is_numeric($numberOfAbsencesCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfAbsencesCreated)), __LINE__);
        }
        $this->NumberOfAbsencesCreated = $numberOfAbsencesCreated;
        return $this;
    }
    /**
     * Get HasError value
     * @return bool
     */
    public function getHasError()
    {
        return $this->HasError;
    }
    /**
     * Set HasError value
     * @param bool $hasError
     * @return \StructType\CreationResult
     */
    public function setHasError($hasError = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasError) && !is_bool($hasError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasError)), __LINE__);
        }
        $this->HasError = $hasError;
        return $this;
    }
    /**
     * Get AbsencesRejected value
     * @return \ArrayType\ArrayOfAbsenceRejectedResult|null
     */
    public function getAbsencesRejected()
    {
        return $this->AbsencesRejected;
    }
    /**
     * Set AbsencesRejected value
     * @param \ArrayType\ArrayOfAbsenceRejectedResult $absencesRejected
     * @return \StructType\CreationResult
     */
    public function setAbsencesRejected(\ArrayType\ArrayOfAbsenceRejectedResult $absencesRejected = null)
    {
        $this->AbsencesRejected = $absencesRejected;
        return $this;
    }
    /**
     * Get RepercussionErrors value
     * @return \ArrayType\ArrayOfRepercussionResult|null
     */
    public function getRepercussionErrors()
    {
        return $this->RepercussionErrors;
    }
    /**
     * Set RepercussionErrors value
     * @param \ArrayType\ArrayOfRepercussionResult $repercussionErrors
     * @return \StructType\CreationResult
     */
    public function setRepercussionErrors(\ArrayType\ArrayOfRepercussionResult $repercussionErrors = null)
    {
        $this->RepercussionErrors = $repercussionErrors;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
