<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbsenceRejectedResult StructType
 * @subpackage Structs
 */
class AbsenceRejectedResult extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Absence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Absence
     */
    public $Absence;
    /**
     * The SessionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionName;
    /**
     * The TraineeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TraineeName;
    /**
     * Constructor method for AbsenceRejectedResult
     * @uses AbsenceRejectedResult::setType()
     * @uses AbsenceRejectedResult::setAbsence()
     * @uses AbsenceRejectedResult::setSessionName()
     * @uses AbsenceRejectedResult::setTraineeName()
     * @param string $type
     * @param \StructType\Absence $absence
     * @param string $sessionName
     * @param string $traineeName
     */
    public function __construct($type = null, \StructType\Absence $absence = null, $sessionName = null, $traineeName = null)
    {
        $this
            ->setType($type)
            ->setAbsence($absence)
            ->setSessionName($sessionName)
            ->setTraineeName($traineeName);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\AbsenceRejectedType::valueIsValid()
     * @uses \EnumType\AbsenceRejectedType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\AbsenceRejectedResult
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AbsenceRejectedType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\AbsenceRejectedType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Absence value
     * @return \StructType\Absence|null
     */
    public function getAbsence()
    {
        return $this->Absence;
    }
    /**
     * Set Absence value
     * @param \StructType\Absence $absence
     * @return \StructType\AbsenceRejectedResult
     */
    public function setAbsence(\StructType\Absence $absence = null)
    {
        $this->Absence = $absence;
        return $this;
    }
    /**
     * Get SessionName value
     * @return string|null
     */
    public function getSessionName()
    {
        return $this->SessionName;
    }
    /**
     * Set SessionName value
     * @param string $sessionName
     * @return \StructType\AbsenceRejectedResult
     */
    public function setSessionName($sessionName = null)
    {
        // validation for constraint: string
        if (!is_null($sessionName) && !is_string($sessionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionName)), __LINE__);
        }
        $this->SessionName = $sessionName;
        return $this;
    }
    /**
     * Get TraineeName value
     * @return string|null
     */
    public function getTraineeName()
    {
        return $this->TraineeName;
    }
    /**
     * Set TraineeName value
     * @param string $traineeName
     * @return \StructType\AbsenceRejectedResult
     */
    public function setTraineeName($traineeName = null)
    {
        // validation for constraint: string
        if (!is_null($traineeName) && !is_string($traineeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traineeName)), __LINE__);
        }
        $this->TraineeName = $traineeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbsenceRejectedResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
