<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unlock ServiceType
 * @subpackage Services
 */
class Unlock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnlockProcessTree
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnlockProcessTree $parameters
     * @return \StructType\UnlockProcessTreeResponse|bool
     */
    public function UnlockProcessTree(\StructType\UnlockProcessTree $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UnlockProcessTree($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UnlockProcessTreeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
