<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddModule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddModule $parameters
     * @return \StructType\AddModuleResponse|bool
     */
    public function AddModule(\StructType\AddModule $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddModule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddModuleXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddModuleXml $parameters
     * @return \StructType\AddModuleXmlResponse|bool
     */
    public function AddModuleXml(\StructType\AddModuleXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddModuleXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addArticleFactModule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddArticleFactModule $parameters
     * @return \StructType\AddArticleFactModuleResponse|bool
     */
    public function addArticleFactModule(\StructType\AddArticleFactModule $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->addArticleFactModule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addArticleFactModuleXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddArticleFactModuleXml $parameters
     * @return \StructType\AddArticleFactModuleXmlResponse|bool
     */
    public function addArticleFactModuleXml(\StructType\AddArticleFactModuleXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->addArticleFactModuleXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddEnrollmentIntendedToPlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddEnrollmentIntendedToPlan $parameters
     * @return \StructType\AddEnrollmentIntendedToPlanResponse|bool
     */
    public function AddEnrollmentIntendedToPlan(\StructType\AddEnrollmentIntendedToPlan $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddEnrollmentIntendedToPlan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddInscriptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddInscriptions $parameters
     * @return \StructType\AddInscriptionsResponse|bool
     */
    public function AddInscriptions(\StructType\AddInscriptions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddInscriptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddEnrollment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddEnrollment $parameters
     * @return \StructType\AddEnrollmentResponse|bool
     */
    public function AddEnrollment(\StructType\AddEnrollment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddEnrollment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddEnrollmentWithState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddEnrollmentWithState $parameters
     * @return \StructType\AddEnrollmentWithStateResponse|bool
     */
    public function AddEnrollmentWithState(\StructType\AddEnrollmentWithState $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddEnrollmentWithState($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddEnrollmentWithStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddEnrollmentWithStatus $parameters
     * @return \StructType\AddEnrollmentWithStatusResponse|bool
     */
    public function AddEnrollmentWithStatus(\StructType\AddEnrollmentWithStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddEnrollmentWithStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSession $parameters
     * @return \StructType\AddSessionResponse|bool
     */
    public function AddSession(\StructType\AddSession $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSessionXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSessionXml $parameters
     * @return \StructType\AddSessionXmlResponse|bool
     */
    public function AddSessionXml(\StructType\AddSessionXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSessionXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSessionGafad
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSessionGafad $parameters
     * @return \StructType\AddSessionGafadResponse|bool
     */
    public function AddSessionGafad(\StructType\AddSessionGafad $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSessionGafad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addArticleFactProcess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddArticleFactProcess $parameters
     * @return \StructType\AddArticleFactProcessResponse|bool
     */
    public function addArticleFactProcess(\StructType\AddArticleFactProcess $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->addArticleFactProcess($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addArticleFactProcessXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddArticleFactProcessXml $parameters
     * @return \StructType\AddArticleFactProcessXmlResponse|bool
     */
    public function addArticleFactProcessXml(\StructType\AddArticleFactProcessXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->addArticleFactProcessXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddEvenementFPC
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddEvenementFPC $parameters
     * @return \StructType\AddEvenementFPCResponse|bool
     */
    public function AddEvenementFPC(\StructType\AddEvenementFPC $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddEvenementFPC($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddInscriptionsNN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddInscriptionsNN $parameters
     * @return \StructType\AddInscriptionsNNResponse|bool
     */
    public function AddInscriptionsNN(\StructType\AddInscriptionsNN $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddInscriptionsNN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddInscriptionsNNXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddInscriptionsNNXml $parameters
     * @return \StructType\AddInscriptionsNNXmlResponse|bool
     */
    public function AddInscriptionsNNXml(\StructType\AddInscriptionsNNXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddInscriptionsNNXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddArticleFactModuleResponse|\StructType\AddArticleFactModuleXmlResponse|\StructType\AddArticleFactProcessResponse|\StructType\AddArticleFactProcessXmlResponse|\StructType\AddEnrollmentIntendedToPlanResponse|\StructType\AddEnrollmentResponse|\StructType\AddEnrollmentWithStateResponse|\StructType\AddEnrollmentWithStatusResponse|\StructType\AddEvenementFPCResponse|\StructType\AddInscriptionsNNResponse|\StructType\AddInscriptionsNNXmlResponse|\StructType\AddInscriptionsResponse|\StructType\AddModuleResponse|\StructType\AddModuleXmlResponse|\StructType\AddSessionGafadResponse|\StructType\AddSessionResponse|\StructType\AddSessionXmlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
