<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://promethee.emse.fr/opdotnet/webservices/formation.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://promethee.emse.fr/opdotnet/webservices/formation.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Ofl ServiceType
 */
$ofl = new \ServiceType\Ofl($options);
/**
 * Sample call for OflGetPaniers operation/method
 */
if ($ofl->OflGetPaniers(new \StructType\OflGetPaniers()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflGetPaniersXml operation/method
 */
if ($ofl->OflGetPaniersXml(new \StructType\OflGetPaniersXml()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflAddCandidature operation/method
 */
if ($ofl->OflAddCandidature(new \StructType\OflAddCandidature()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflAddCandidatureXml operation/method
 */
if ($ofl->OflAddCandidatureXml(new \StructType\OflAddCandidatureXml()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflSuppCandidature operation/method
 */
if ($ofl->OflSuppCandidature(new \StructType\OflSuppCandidature()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflSuppCandidatureXml operation/method
 */
if ($ofl->OflSuppCandidatureXml(new \StructType\OflSuppCandidatureXml()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflValidationCandidature operation/method
 */
if ($ofl->OflValidationCandidature(new \StructType\OflValidationCandidature()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflValidationCandidatureXml operation/method
 */
if ($ofl->OflValidationCandidatureXml(new \StructType\OflValidationCandidatureXml()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflMajCommentaire operation/method
 */
if ($ofl->OflMajCommentaire(new \StructType\OflMajCommentaire()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflMajCommentaireXml operation/method
 */
if ($ofl->OflMajCommentaireXml(new \StructType\OflMajCommentaireXml()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflMajOrdreCandidatures operation/method
 */
if ($ofl->OflMajOrdreCandidatures(new \StructType\OflMajOrdreCandidatures()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Sample call for OflMajOrdreCandidaturesXml operation/method
 */
if ($ofl->OflMajOrdreCandidaturesXml(new \StructType\OflMajOrdreCandidaturesXml()) !== false) {
    print_r($ofl->getResult());
} else {
    print_r($ofl->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateSessionStatus operation/method
 */
if ($update->UpdateSessionStatus(new \StructType\UpdateSessionStatus()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAbsences operation/method
 */
if ($update->UpdateAbsences(new \StructType\UpdateAbsences()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getModule operation/method
 */
if ($get->getModule(new \StructType\GetModule()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModuleXml operation/method
 */
if ($get->getModuleXml(new \StructType\GetModuleXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOffre operation/method
 */
if ($get->getOffre(new \StructType\GetOffre()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOffreXml operation/method
 */
if ($get->getOffreXml(new \StructType\GetOffreXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInscriptions operation/method
 */
if ($get->getInscriptions(new \StructType\GetInscriptions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInscriptionsDifferentielXml operation/method
 */
if ($get->getInscriptionsDifferentielXml(new \StructType\GetInscriptionsDifferentielXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInscriptionsDifferentiel operation/method
 */
if ($get->getInscriptionsDifferentiel(new \StructType\GetInscriptionsDifferentiel()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInscriptionsXml operation/method
 */
if ($get->getInscriptionsXml(new \StructType\GetInscriptionsXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSessionByCode operation/method
 */
if ($get->getSessionByCode(new \StructType\GetSessionByCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSessionByCodeXml operation/method
 */
if ($get->getSessionByCodeXml(new \StructType\GetSessionByCodeXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSession operation/method
 */
if ($get->getSession(new \StructType\GetSession()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSessionsDifferentiel operation/method
 */
if ($get->getSessionsDifferentiel(new \StructType\GetSessionsDifferentiel()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSessionsDifferentielXML operation/method
 */
if ($get->getSessionsDifferentielXML(new \StructType\GetSessionsDifferentielXML()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSessionXml operation/method
 */
if ($get->getSessionXml(new \StructType\GetSessionXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDomaines operation/method
 */
if ($get->getDomaines(new \StructType\GetDomaines()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDomainesXml operation/method
 */
if ($get->getDomainesXml(new \StructType\GetDomainesXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEvaluationByCode operation/method
 */
if ($get->GetEvaluationByCode(new \StructType\GetEvaluationByCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMarksBySession operation/method
 */
if ($get->GetMarksBySession(new \StructType\GetMarksBySession()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMarksBySessionAssessment operation/method
 */
if ($get->GetMarksBySessionAssessment(new \StructType\GetMarksBySessionAssessment()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMarksBySessionAssessmentStudent operation/method
 */
if ($get->GetMarksBySessionAssessmentStudent(new \StructType\GetMarksBySessionAssessmentStudent()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMarksByStudent operation/method
 */
if ($get->GetMarksByStudent(new \StructType\GetMarksByStudent()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMarksByStudentSession operation/method
 */
if ($get->GetMarksByStudentSession(new \StructType\GetMarksByStudentSession()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMarksByStudentSessionAssessment operation/method
 */
if ($get->GetMarksByStudentSessionAssessment(new \StructType\GetMarksByStudentSessionAssessment()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProprietes operation/method
 */
if ($get->getProprietes(new \StructType\GetProprietes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProprietesXml operation/method
 */
if ($get->getProprietesXml(new \StructType\GetProprietesXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAbsences operation/method
 */
if ($get->GetAbsences(new \StructType\GetAbsences()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddModule operation/method
 */
if ($add->AddModule(new \StructType\AddModule()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddModuleXml operation/method
 */
if ($add->AddModuleXml(new \StructType\AddModuleXml()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addArticleFactModule operation/method
 */
if ($add->addArticleFactModule(new \StructType\AddArticleFactModule()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addArticleFactModuleXml operation/method
 */
if ($add->addArticleFactModuleXml(new \StructType\AddArticleFactModuleXml()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddEnrollmentIntendedToPlan operation/method
 */
if ($add->AddEnrollmentIntendedToPlan(new \StructType\AddEnrollmentIntendedToPlan()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddInscriptions operation/method
 */
if ($add->AddInscriptions(new \StructType\AddInscriptions()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddEnrollment operation/method
 */
if ($add->AddEnrollment(new \StructType\AddEnrollment()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddEnrollmentWithState operation/method
 */
if ($add->AddEnrollmentWithState(new \StructType\AddEnrollmentWithState()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddEnrollmentWithStatus operation/method
 */
if ($add->AddEnrollmentWithStatus(new \StructType\AddEnrollmentWithStatus()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSession operation/method
 */
if ($add->AddSession(new \StructType\AddSession()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSessionXml operation/method
 */
if ($add->AddSessionXml(new \StructType\AddSessionXml()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSessionGafad operation/method
 */
if ($add->AddSessionGafad(new \StructType\AddSessionGafad()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addArticleFactProcess operation/method
 */
if ($add->addArticleFactProcess(new \StructType\AddArticleFactProcess()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addArticleFactProcessXml operation/method
 */
if ($add->addArticleFactProcessXml(new \StructType\AddArticleFactProcessXml()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddEvenementFPC operation/method
 */
if ($add->AddEvenementFPC(new \StructType\AddEvenementFPC()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddInscriptionsNN operation/method
 */
if ($add->AddInscriptionsNN(new \StructType\AddInscriptionsNN()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddInscriptionsNNXml operation/method
 */
if ($add->AddInscriptionsNNXml(new \StructType\AddInscriptionsNNXml()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Compute ServiceType
 */
$compute = new \ServiceType\Compute($options);
/**
 * Sample call for ComputeProcessTreeGrades operation/method
 */
if ($compute->ComputeProcessTreeGrades(new \StructType\ComputeProcessTreeGrades()) !== false) {
    print_r($compute->getResult());
} else {
    print_r($compute->getLastError());
}
/**
 * Samples for Unlock ServiceType
 */
$unlock = new \ServiceType\Unlock($options);
/**
 * Sample call for UnlockProcessTree operation/method
 */
if ($unlock->UnlockProcessTree(new \StructType\UnlockProcessTree()) !== false) {
    print_r($unlock->getResult());
} else {
    print_r($unlock->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for SaveGrade operation/method
 */
if ($save->SaveGrade(new \StructType\SaveGrade()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteGrade operation/method
 */
if ($delete->DeleteGrade(new \StructType\DeleteGrade()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteAbsences operation/method
 */
if ($delete->DeleteAbsences(new \StructType\DeleteAbsences()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for setPropriete operation/method
 */
if ($set->setPropriete(new \StructType\SetPropriete()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setProprieteXml operation/method
 */
if ($set->setProprieteXml(new \StructType\SetProprieteXml()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateAbsences operation/method
 */
if ($create->CreateAbsences(new \StructType\CreateAbsences()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
