<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveGrade StructType
 * @subpackage Structs
 */
class SaveGrade extends AbstractStructBase
{
    /**
     * The communityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $communityId;
    /**
     * The studentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $studentId;
    /**
     * The processId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $processId;
    /**
     * The evaluationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $evaluationId;
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $guid;
    /**
     * The gradeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gradeValue;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The isOff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $isOff;
    /**
     * The isExempted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $isExempted;
    /**
     * The isJustifiedAbsence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $isJustifiedAbsence;
    /**
     * Constructor method for SaveGrade
     * @uses SaveGrade::setCommunityId()
     * @uses SaveGrade::setStudentId()
     * @uses SaveGrade::setProcessId()
     * @uses SaveGrade::setEvaluationId()
     * @uses SaveGrade::setGuid()
     * @uses SaveGrade::setGradeValue()
     * @uses SaveGrade::setComment()
     * @uses SaveGrade::setIsOff()
     * @uses SaveGrade::setIsExempted()
     * @uses SaveGrade::setIsJustifiedAbsence()
     * @param int $communityId
     * @param int $studentId
     * @param int $processId
     * @param int $evaluationId
     * @param string $guid
     * @param string $gradeValue
     * @param string $comment
     * @param string $isOff
     * @param string $isExempted
     * @param string $isJustifiedAbsence
     */
    public function __construct($communityId = null, $studentId = null, $processId = null, $evaluationId = null, $guid = null, $gradeValue = null, $comment = null, $isOff = null, $isExempted = null, $isJustifiedAbsence = null)
    {
        $this
            ->setCommunityId($communityId)
            ->setStudentId($studentId)
            ->setProcessId($processId)
            ->setEvaluationId($evaluationId)
            ->setGuid($guid)
            ->setGradeValue($gradeValue)
            ->setComment($comment)
            ->setIsOff($isOff)
            ->setIsExempted($isExempted)
            ->setIsJustifiedAbsence($isJustifiedAbsence);
    }
    /**
     * Get communityId value
     * @return int
     */
    public function getCommunityId()
    {
        return $this->communityId;
    }
    /**
     * Set communityId value
     * @param int $communityId
     * @return \StructType\SaveGrade
     */
    public function setCommunityId($communityId = null)
    {
        // validation for constraint: int
        if (!is_null($communityId) && !is_numeric($communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($communityId)), __LINE__);
        }
        $this->communityId = $communityId;
        return $this;
    }
    /**
     * Get studentId value
     * @return int
     */
    public function getStudentId()
    {
        return $this->studentId;
    }
    /**
     * Set studentId value
     * @param int $studentId
     * @return \StructType\SaveGrade
     */
    public function setStudentId($studentId = null)
    {
        // validation for constraint: int
        if (!is_null($studentId) && !is_numeric($studentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($studentId)), __LINE__);
        }
        $this->studentId = $studentId;
        return $this;
    }
    /**
     * Get processId value
     * @return int
     */
    public function getProcessId()
    {
        return $this->processId;
    }
    /**
     * Set processId value
     * @param int $processId
     * @return \StructType\SaveGrade
     */
    public function setProcessId($processId = null)
    {
        // validation for constraint: int
        if (!is_null($processId) && !is_numeric($processId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($processId)), __LINE__);
        }
        $this->processId = $processId;
        return $this;
    }
    /**
     * Get evaluationId value
     * @return int
     */
    public function getEvaluationId()
    {
        return $this->evaluationId;
    }
    /**
     * Set evaluationId value
     * @param int $evaluationId
     * @return \StructType\SaveGrade
     */
    public function setEvaluationId($evaluationId = null)
    {
        // validation for constraint: int
        if (!is_null($evaluationId) && !is_numeric($evaluationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($evaluationId)), __LINE__);
        }
        $this->evaluationId = $evaluationId;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\SaveGrade
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get gradeValue value
     * @return string|null
     */
    public function getGradeValue()
    {
        return $this->gradeValue;
    }
    /**
     * Set gradeValue value
     * @param string $gradeValue
     * @return \StructType\SaveGrade
     */
    public function setGradeValue($gradeValue = null)
    {
        // validation for constraint: string
        if (!is_null($gradeValue) && !is_string($gradeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gradeValue)), __LINE__);
        }
        $this->gradeValue = $gradeValue;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\SaveGrade
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get isOff value
     * @return string|null
     */
    public function getIsOff()
    {
        return $this->isOff;
    }
    /**
     * Set isOff value
     * @param string $isOff
     * @return \StructType\SaveGrade
     */
    public function setIsOff($isOff = null)
    {
        // validation for constraint: string
        if (!is_null($isOff) && !is_string($isOff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isOff)), __LINE__);
        }
        $this->isOff = $isOff;
        return $this;
    }
    /**
     * Get isExempted value
     * @return string|null
     */
    public function getIsExempted()
    {
        return $this->isExempted;
    }
    /**
     * Set isExempted value
     * @param string $isExempted
     * @return \StructType\SaveGrade
     */
    public function setIsExempted($isExempted = null)
    {
        // validation for constraint: string
        if (!is_null($isExempted) && !is_string($isExempted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isExempted)), __LINE__);
        }
        $this->isExempted = $isExempted;
        return $this;
    }
    /**
     * Get isJustifiedAbsence value
     * @return string|null
     */
    public function getIsJustifiedAbsence()
    {
        return $this->isJustifiedAbsence;
    }
    /**
     * Set isJustifiedAbsence value
     * @param string $isJustifiedAbsence
     * @return \StructType\SaveGrade
     */
    public function setIsJustifiedAbsence($isJustifiedAbsence = null)
    {
        // validation for constraint: string
        if (!is_null($isJustifiedAbsence) && !is_string($isJustifiedAbsence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isJustifiedAbsence)), __LINE__);
        }
        $this->isJustifiedAbsence = $isJustifiedAbsence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaveGrade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
