<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMarksByStudentSessionAssessment StructType
 * @subpackage Structs
 */
class GetMarksByStudentSessionAssessment extends AbstractStructBase
{
    /**
     * The communityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $communityId;
    /**
     * The studentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $studentId;
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $sessionId;
    /**
     * The assessmentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $assessmentId;
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $guid;
    /**
     * Constructor method for GetMarksByStudentSessionAssessment
     * @uses GetMarksByStudentSessionAssessment::setCommunityId()
     * @uses GetMarksByStudentSessionAssessment::setStudentId()
     * @uses GetMarksByStudentSessionAssessment::setSessionId()
     * @uses GetMarksByStudentSessionAssessment::setAssessmentId()
     * @uses GetMarksByStudentSessionAssessment::setGuid()
     * @param int $communityId
     * @param int $studentId
     * @param int $sessionId
     * @param int $assessmentId
     * @param string $guid
     */
    public function __construct($communityId = null, $studentId = null, $sessionId = null, $assessmentId = null, $guid = null)
    {
        $this
            ->setCommunityId($communityId)
            ->setStudentId($studentId)
            ->setSessionId($sessionId)
            ->setAssessmentId($assessmentId)
            ->setGuid($guid);
    }
    /**
     * Get communityId value
     * @return int
     */
    public function getCommunityId()
    {
        return $this->communityId;
    }
    /**
     * Set communityId value
     * @param int $communityId
     * @return \StructType\GetMarksByStudentSessionAssessment
     */
    public function setCommunityId($communityId = null)
    {
        // validation for constraint: int
        if (!is_null($communityId) && !is_numeric($communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($communityId)), __LINE__);
        }
        $this->communityId = $communityId;
        return $this;
    }
    /**
     * Get studentId value
     * @return int
     */
    public function getStudentId()
    {
        return $this->studentId;
    }
    /**
     * Set studentId value
     * @param int $studentId
     * @return \StructType\GetMarksByStudentSessionAssessment
     */
    public function setStudentId($studentId = null)
    {
        // validation for constraint: int
        if (!is_null($studentId) && !is_numeric($studentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($studentId)), __LINE__);
        }
        $this->studentId = $studentId;
        return $this;
    }
    /**
     * Get sessionId value
     * @return int
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param int $sessionId
     * @return \StructType\GetMarksByStudentSessionAssessment
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: int
        if (!is_null($sessionId) && !is_numeric($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get assessmentId value
     * @return int
     */
    public function getAssessmentId()
    {
        return $this->assessmentId;
    }
    /**
     * Set assessmentId value
     * @param int $assessmentId
     * @return \StructType\GetMarksByStudentSessionAssessment
     */
    public function setAssessmentId($assessmentId = null)
    {
        // validation for constraint: int
        if (!is_null($assessmentId) && !is_numeric($assessmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($assessmentId)), __LINE__);
        }
        $this->assessmentId = $assessmentId;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\GetMarksByStudentSessionAssessment
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMarksByStudentSessionAssessment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
