<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEvaluationByCode StructType
 * @subpackage Structs
 */
class GetEvaluationByCode extends AbstractStructBase
{
    /**
     * The communityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $communityId;
    /**
     * The processId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $processId;
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $guid;
    /**
     * The evaluationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $evaluationCode;
    /**
     * Constructor method for GetEvaluationByCode
     * @uses GetEvaluationByCode::setCommunityId()
     * @uses GetEvaluationByCode::setProcessId()
     * @uses GetEvaluationByCode::setGuid()
     * @uses GetEvaluationByCode::setEvaluationCode()
     * @param int $communityId
     * @param int $processId
     * @param string $guid
     * @param string $evaluationCode
     */
    public function __construct($communityId = null, $processId = null, $guid = null, $evaluationCode = null)
    {
        $this
            ->setCommunityId($communityId)
            ->setProcessId($processId)
            ->setGuid($guid)
            ->setEvaluationCode($evaluationCode);
    }
    /**
     * Get communityId value
     * @return int
     */
    public function getCommunityId()
    {
        return $this->communityId;
    }
    /**
     * Set communityId value
     * @param int $communityId
     * @return \StructType\GetEvaluationByCode
     */
    public function setCommunityId($communityId = null)
    {
        // validation for constraint: int
        if (!is_null($communityId) && !is_numeric($communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($communityId)), __LINE__);
        }
        $this->communityId = $communityId;
        return $this;
    }
    /**
     * Get processId value
     * @return int
     */
    public function getProcessId()
    {
        return $this->processId;
    }
    /**
     * Set processId value
     * @param int $processId
     * @return \StructType\GetEvaluationByCode
     */
    public function setProcessId($processId = null)
    {
        // validation for constraint: int
        if (!is_null($processId) && !is_numeric($processId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($processId)), __LINE__);
        }
        $this->processId = $processId;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\GetEvaluationByCode
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get evaluationCode value
     * @return string|null
     */
    public function getEvaluationCode()
    {
        return $this->evaluationCode;
    }
    /**
     * Set evaluationCode value
     * @param string $evaluationCode
     * @return \StructType\GetEvaluationByCode
     */
    public function setEvaluationCode($evaluationCode = null)
    {
        // validation for constraint: string
        if (!is_null($evaluationCode) && !is_string($evaluationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($evaluationCode)), __LINE__);
        }
        $this->evaluationCode = $evaluationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEvaluationByCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
