<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComputeProcessTreeGrades StructType
 * @subpackage Structs
 */
class ComputeProcessTreeGrades extends AbstractStructBase
{
    /**
     * The CommunityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommunityId;
    /**
     * The ProcessId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProcessId;
    /**
     * The Guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guid;
    /**
     * Constructor method for ComputeProcessTreeGrades
     * @uses ComputeProcessTreeGrades::setCommunityId()
     * @uses ComputeProcessTreeGrades::setProcessId()
     * @uses ComputeProcessTreeGrades::setGuid()
     * @param int $communityId
     * @param int $processId
     * @param string $guid
     */
    public function __construct($communityId = null, $processId = null, $guid = null)
    {
        $this
            ->setCommunityId($communityId)
            ->setProcessId($processId)
            ->setGuid($guid);
    }
    /**
     * Get CommunityId value
     * @return int
     */
    public function getCommunityId()
    {
        return $this->CommunityId;
    }
    /**
     * Set CommunityId value
     * @param int $communityId
     * @return \StructType\ComputeProcessTreeGrades
     */
    public function setCommunityId($communityId = null)
    {
        // validation for constraint: int
        if (!is_null($communityId) && !is_numeric($communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($communityId)), __LINE__);
        }
        $this->CommunityId = $communityId;
        return $this;
    }
    /**
     * Get ProcessId value
     * @return int
     */
    public function getProcessId()
    {
        return $this->ProcessId;
    }
    /**
     * Set ProcessId value
     * @param int $processId
     * @return \StructType\ComputeProcessTreeGrades
     */
    public function setProcessId($processId = null)
    {
        // validation for constraint: int
        if (!is_null($processId) && !is_numeric($processId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($processId)), __LINE__);
        }
        $this->ProcessId = $processId;
        return $this;
    }
    /**
     * Get Guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->Guid;
    }
    /**
     * Set Guid value
     * @param string $guid
     * @return \StructType\ComputeProcessTreeGrades
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->Guid = $guid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ComputeProcessTreeGrades
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
