<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddEnrollmentIntendedToPlan StructType
 * @subpackage Structs
 */
class AddEnrollmentIntendedToPlan extends AbstractStructBase
{
    /**
     * The ComunityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ComunityId;
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $sessionId;
    /**
     * The traineeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $traineeId;
    /**
     * The enrollmentMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $enrollmentMode;
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $guid;
    /**
     * The enrollmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enrollmentDate;
    /**
     * The enrollmentOrgList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enrollmentOrgList;
    /**
     * The invoicingOrgList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoicingOrgList;
    /**
     * The invoicingPersList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoicingPersList;
    /**
     * The fieldList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fieldList;
    /**
     * The invoicingItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoicingItems;
    /**
     * Constructor method for AddEnrollmentIntendedToPlan
     * @uses AddEnrollmentIntendedToPlan::setComunityId()
     * @uses AddEnrollmentIntendedToPlan::setSessionId()
     * @uses AddEnrollmentIntendedToPlan::setTraineeId()
     * @uses AddEnrollmentIntendedToPlan::setEnrollmentMode()
     * @uses AddEnrollmentIntendedToPlan::setGuid()
     * @uses AddEnrollmentIntendedToPlan::setEnrollmentDate()
     * @uses AddEnrollmentIntendedToPlan::setEnrollmentOrgList()
     * @uses AddEnrollmentIntendedToPlan::setInvoicingOrgList()
     * @uses AddEnrollmentIntendedToPlan::setInvoicingPersList()
     * @uses AddEnrollmentIntendedToPlan::setFieldList()
     * @uses AddEnrollmentIntendedToPlan::setInvoicingItems()
     * @param int $comunityId
     * @param int $sessionId
     * @param int $traineeId
     * @param string $enrollmentMode
     * @param string $guid
     * @param string $enrollmentDate
     * @param string $enrollmentOrgList
     * @param string $invoicingOrgList
     * @param string $invoicingPersList
     * @param string $fieldList
     * @param string $invoicingItems
     */
    public function __construct($comunityId = null, $sessionId = null, $traineeId = null, $enrollmentMode = null, $guid = null, $enrollmentDate = null, $enrollmentOrgList = null, $invoicingOrgList = null, $invoicingPersList = null, $fieldList = null, $invoicingItems = null)
    {
        $this
            ->setComunityId($comunityId)
            ->setSessionId($sessionId)
            ->setTraineeId($traineeId)
            ->setEnrollmentMode($enrollmentMode)
            ->setGuid($guid)
            ->setEnrollmentDate($enrollmentDate)
            ->setEnrollmentOrgList($enrollmentOrgList)
            ->setInvoicingOrgList($invoicingOrgList)
            ->setInvoicingPersList($invoicingPersList)
            ->setFieldList($fieldList)
            ->setInvoicingItems($invoicingItems);
    }
    /**
     * Get ComunityId value
     * @return int
     */
    public function getComunityId()
    {
        return $this->ComunityId;
    }
    /**
     * Set ComunityId value
     * @param int $comunityId
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setComunityId($comunityId = null)
    {
        // validation for constraint: int
        if (!is_null($comunityId) && !is_numeric($comunityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($comunityId)), __LINE__);
        }
        $this->ComunityId = $comunityId;
        return $this;
    }
    /**
     * Get sessionId value
     * @return int
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param int $sessionId
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: int
        if (!is_null($sessionId) && !is_numeric($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get traineeId value
     * @return int
     */
    public function getTraineeId()
    {
        return $this->traineeId;
    }
    /**
     * Set traineeId value
     * @param int $traineeId
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setTraineeId($traineeId = null)
    {
        // validation for constraint: int
        if (!is_null($traineeId) && !is_numeric($traineeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($traineeId)), __LINE__);
        }
        $this->traineeId = $traineeId;
        return $this;
    }
    /**
     * Get enrollmentMode value
     * @return string
     */
    public function getEnrollmentMode()
    {
        return $this->enrollmentMode;
    }
    /**
     * Set enrollmentMode value
     * @uses \EnumType\ModesInscriptions::valueIsValid()
     * @uses \EnumType\ModesInscriptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $enrollmentMode
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setEnrollmentMode($enrollmentMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModesInscriptions::valueIsValid($enrollmentMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $enrollmentMode, implode(', ', \EnumType\ModesInscriptions::getValidValues())), __LINE__);
        }
        $this->enrollmentMode = $enrollmentMode;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get enrollmentDate value
     * @return string|null
     */
    public function getEnrollmentDate()
    {
        return $this->enrollmentDate;
    }
    /**
     * Set enrollmentDate value
     * @param string $enrollmentDate
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setEnrollmentDate($enrollmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentDate) && !is_string($enrollmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollmentDate)), __LINE__);
        }
        $this->enrollmentDate = $enrollmentDate;
        return $this;
    }
    /**
     * Get enrollmentOrgList value
     * @return string|null
     */
    public function getEnrollmentOrgList()
    {
        return $this->enrollmentOrgList;
    }
    /**
     * Set enrollmentOrgList value
     * @param string $enrollmentOrgList
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setEnrollmentOrgList($enrollmentOrgList = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentOrgList) && !is_string($enrollmentOrgList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollmentOrgList)), __LINE__);
        }
        $this->enrollmentOrgList = $enrollmentOrgList;
        return $this;
    }
    /**
     * Get invoicingOrgList value
     * @return string|null
     */
    public function getInvoicingOrgList()
    {
        return $this->invoicingOrgList;
    }
    /**
     * Set invoicingOrgList value
     * @param string $invoicingOrgList
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setInvoicingOrgList($invoicingOrgList = null)
    {
        // validation for constraint: string
        if (!is_null($invoicingOrgList) && !is_string($invoicingOrgList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoicingOrgList)), __LINE__);
        }
        $this->invoicingOrgList = $invoicingOrgList;
        return $this;
    }
    /**
     * Get invoicingPersList value
     * @return string|null
     */
    public function getInvoicingPersList()
    {
        return $this->invoicingPersList;
    }
    /**
     * Set invoicingPersList value
     * @param string $invoicingPersList
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setInvoicingPersList($invoicingPersList = null)
    {
        // validation for constraint: string
        if (!is_null($invoicingPersList) && !is_string($invoicingPersList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoicingPersList)), __LINE__);
        }
        $this->invoicingPersList = $invoicingPersList;
        return $this;
    }
    /**
     * Get fieldList value
     * @return string|null
     */
    public function getFieldList()
    {
        return $this->fieldList;
    }
    /**
     * Set fieldList value
     * @param string $fieldList
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setFieldList($fieldList = null)
    {
        // validation for constraint: string
        if (!is_null($fieldList) && !is_string($fieldList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fieldList)), __LINE__);
        }
        $this->fieldList = $fieldList;
        return $this;
    }
    /**
     * Get invoicingItems value
     * @return string|null
     */
    public function getInvoicingItems()
    {
        return $this->invoicingItems;
    }
    /**
     * Set invoicingItems value
     * @param string $invoicingItems
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public function setInvoicingItems($invoicingItems = null)
    {
        // validation for constraint: string
        if (!is_null($invoicingItems) && !is_string($invoicingItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoicingItems)), __LINE__);
        }
        $this->invoicingItems = $invoicingItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddEnrollmentIntendedToPlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
