<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Absence StructType
 * @subpackage Structs
 */
class Absence extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The DeclarationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeclarationId;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The EventId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EventId;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Duration;
    /**
     * The PersonId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonId;
    /**
     * The Justified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Justified;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonName;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The ReasonCodeForAbsence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonCodeForAbsence;
    /**
     * Constructor method for Absence
     * @uses Absence::setId()
     * @uses Absence::setDeclarationId()
     * @uses Absence::setStartDate()
     * @uses Absence::setEndDate()
     * @uses Absence::setEventId()
     * @uses Absence::setDuration()
     * @uses Absence::setPersonId()
     * @uses Absence::setJustified()
     * @uses Absence::setPersonName()
     * @uses Absence::setComment()
     * @uses Absence::setReasonCodeForAbsence()
     * @param int $id
     * @param int $declarationId
     * @param string $startDate
     * @param string $endDate
     * @param int $eventId
     * @param int $duration
     * @param int $personId
     * @param bool $justified
     * @param string $personName
     * @param string $comment
     * @param string $reasonCodeForAbsence
     */
    public function __construct($id = null, $declarationId = null, $startDate = null, $endDate = null, $eventId = null, $duration = null, $personId = null, $justified = null, $personName = null, $comment = null, $reasonCodeForAbsence = null)
    {
        $this
            ->setId($id)
            ->setDeclarationId($declarationId)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setEventId($eventId)
            ->setDuration($duration)
            ->setPersonId($personId)
            ->setJustified($justified)
            ->setPersonName($personName)
            ->setComment($comment)
            ->setReasonCodeForAbsence($reasonCodeForAbsence);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Absence
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get DeclarationId value
     * @return int
     */
    public function getDeclarationId()
    {
        return $this->DeclarationId;
    }
    /**
     * Set DeclarationId value
     * @param int $declarationId
     * @return \StructType\Absence
     */
    public function setDeclarationId($declarationId = null)
    {
        // validation for constraint: int
        if (!is_null($declarationId) && !is_numeric($declarationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($declarationId)), __LINE__);
        }
        $this->DeclarationId = $declarationId;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\Absence
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\Absence
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get EventId value
     * @return int
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param int $eventId
     * @return \StructType\Absence
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: int
        if (!is_null($eventId) && !is_numeric($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\Absence
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get PersonId value
     * @return int
     */
    public function getPersonId()
    {
        return $this->PersonId;
    }
    /**
     * Set PersonId value
     * @param int $personId
     * @return \StructType\Absence
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->PersonId = $personId;
        return $this;
    }
    /**
     * Get Justified value
     * @return bool
     */
    public function getJustified()
    {
        return $this->Justified;
    }
    /**
     * Set Justified value
     * @param bool $justified
     * @return \StructType\Absence
     */
    public function setJustified($justified = null)
    {
        // validation for constraint: boolean
        if (!is_null($justified) && !is_bool($justified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($justified)), __LINE__);
        }
        $this->Justified = $justified;
        return $this;
    }
    /**
     * Get PersonName value
     * @return string|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param string $personName
     * @return \StructType\Absence
     */
    public function setPersonName($personName = null)
    {
        // validation for constraint: string
        if (!is_null($personName) && !is_string($personName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personName)), __LINE__);
        }
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Absence
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get ReasonCodeForAbsence value
     * @return string|null
     */
    public function getReasonCodeForAbsence()
    {
        return $this->ReasonCodeForAbsence;
    }
    /**
     * Set ReasonCodeForAbsence value
     * @param string $reasonCodeForAbsence
     * @return \StructType\Absence
     */
    public function setReasonCodeForAbsence($reasonCodeForAbsence = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCodeForAbsence) && !is_string($reasonCodeForAbsence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reasonCodeForAbsence)), __LINE__);
        }
        $this->ReasonCodeForAbsence = $reasonCodeForAbsence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Absence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
