<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ofl ServiceType
 * @subpackage Services
 */
class Ofl extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OflGetPaniers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflGetPaniers $parameters
     * @return \StructType\OflGetPaniersResponse|bool
     */
    public function OflGetPaniers(\StructType\OflGetPaniers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflGetPaniers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflGetPaniersXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflGetPaniersXml $parameters
     * @return \StructType\OflGetPaniersXmlResponse|bool
     */
    public function OflGetPaniersXml(\StructType\OflGetPaniersXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflGetPaniersXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflAddCandidature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflAddCandidature $parameters
     * @return \StructType\OflAddCandidatureResponse|bool
     */
    public function OflAddCandidature(\StructType\OflAddCandidature $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflAddCandidature($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflAddCandidatureXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflAddCandidatureXml $parameters
     * @return \StructType\OflAddCandidatureXmlResponse|bool
     */
    public function OflAddCandidatureXml(\StructType\OflAddCandidatureXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflAddCandidatureXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflSuppCandidature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflSuppCandidature $parameters
     * @return \StructType\OflSuppCandidatureResponse|bool
     */
    public function OflSuppCandidature(\StructType\OflSuppCandidature $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflSuppCandidature($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflSuppCandidatureXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflSuppCandidatureXml $parameters
     * @return \StructType\OflSuppCandidatureXmlResponse|bool
     */
    public function OflSuppCandidatureXml(\StructType\OflSuppCandidatureXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflSuppCandidatureXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflValidationCandidature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflValidationCandidature $parameters
     * @return \StructType\OflValidationCandidatureResponse|bool
     */
    public function OflValidationCandidature(\StructType\OflValidationCandidature $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflValidationCandidature($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflValidationCandidatureXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflValidationCandidatureXml $parameters
     * @return \StructType\OflValidationCandidatureXmlResponse|bool
     */
    public function OflValidationCandidatureXml(\StructType\OflValidationCandidatureXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflValidationCandidatureXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflMajCommentaire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflMajCommentaire $parameters
     * @return \StructType\OflMajCommentaireResponse|bool
     */
    public function OflMajCommentaire(\StructType\OflMajCommentaire $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflMajCommentaire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflMajCommentaireXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflMajCommentaireXml $parameters
     * @return \StructType\OflMajCommentaireXmlResponse|bool
     */
    public function OflMajCommentaireXml(\StructType\OflMajCommentaireXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflMajCommentaireXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflMajOrdreCandidatures
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflMajOrdreCandidatures $parameters
     * @return \StructType\OflMajOrdreCandidaturesResponse|bool
     */
    public function OflMajOrdreCandidatures(\StructType\OflMajOrdreCandidatures $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflMajOrdreCandidatures($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OflMajOrdreCandidaturesXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OflMajOrdreCandidaturesXml $parameters
     * @return \StructType\OflMajOrdreCandidaturesXmlResponse|bool
     */
    public function OflMajOrdreCandidaturesXml(\StructType\OflMajOrdreCandidaturesXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OflMajOrdreCandidaturesXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OflAddCandidatureResponse|\StructType\OflAddCandidatureXmlResponse|\StructType\OflGetPaniersResponse|\StructType\OflGetPaniersXmlResponse|\StructType\OflMajCommentaireResponse|\StructType\OflMajCommentaireXmlResponse|\StructType\OflMajOrdreCandidaturesResponse|\StructType\OflMajOrdreCandidaturesXmlResponse|\StructType\OflSuppCandidatureResponse|\StructType\OflSuppCandidatureXmlResponse|\StructType\OflValidationCandidatureResponse|\StructType\OflValidationCandidatureXmlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
