<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getModule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModule $parameters
     * @return \StructType\GetModuleResponse|bool
     */
    public function getModule(\StructType\GetModule $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModuleXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModuleXml $parameters
     * @return \StructType\GetModuleXmlResponse|bool
     */
    public function getModuleXml(\StructType\GetModuleXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModuleXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOffre
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOffre $parameters
     * @return \StructType\GetOffreResponse|bool
     */
    public function getOffre(\StructType\GetOffre $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOffre($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOffreXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOffreXml $parameters
     * @return \StructType\GetOffreXmlResponse|bool
     */
    public function getOffreXml(\StructType\GetOffreXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOffreXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInscriptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInscriptions $parameters
     * @return \StructType\GetInscriptionsResponse|bool
     */
    public function getInscriptions(\StructType\GetInscriptions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getInscriptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInscriptionsDifferentielXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInscriptionsDifferentielXml $parameters
     * @return \StructType\GetInscriptionsDifferentielXmlResponse|bool
     */
    public function getInscriptionsDifferentielXml(\StructType\GetInscriptionsDifferentielXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getInscriptionsDifferentielXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInscriptionsDifferentiel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInscriptionsDifferentiel $parameters
     * @return \StructType\GetInscriptionsDifferentielResponse|bool
     */
    public function getInscriptionsDifferentiel(\StructType\GetInscriptionsDifferentiel $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getInscriptionsDifferentiel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInscriptionsXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInscriptionsXml $parameters
     * @return \StructType\GetInscriptionsXmlResponse|bool
     */
    public function getInscriptionsXml(\StructType\GetInscriptionsXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getInscriptionsXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSessionByCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSessionByCode $parameters
     * @return \StructType\GetSessionByCodeResponse|bool
     */
    public function getSessionByCode(\StructType\GetSessionByCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSessionByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSessionByCodeXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSessionByCodeXml $parameters
     * @return \StructType\GetSessionByCodeXmlResponse|bool
     */
    public function getSessionByCodeXml(\StructType\GetSessionByCodeXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSessionByCodeXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSession $parameters
     * @return \StructType\GetSessionResponse|bool
     */
    public function getSession(\StructType\GetSession $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSessionsDifferentiel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSessionsDifferentiel $parameters
     * @return \StructType\GetSessionsDifferentielResponse|bool
     */
    public function getSessionsDifferentiel(\StructType\GetSessionsDifferentiel $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSessionsDifferentiel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSessionsDifferentielXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSessionsDifferentielXML $parameters
     * @return \StructType\GetSessionsDifferentielXMLResponse|bool
     */
    public function getSessionsDifferentielXML(\StructType\GetSessionsDifferentielXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSessionsDifferentielXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSessionXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSessionXml $parameters
     * @return \StructType\GetSessionXmlResponse|bool
     */
    public function getSessionXml(\StructType\GetSessionXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSessionXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDomaines
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDomaines $parameters
     * @return \StructType\GetDomainesResponse|bool
     */
    public function getDomaines(\StructType\GetDomaines $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDomaines($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDomainesXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDomainesXml $parameters
     * @return \StructType\GetDomainesXmlResponse|bool
     */
    public function getDomainesXml(\StructType\GetDomainesXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDomainesXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEvaluationByCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEvaluationByCode $parameters
     * @return \StructType\GetEvaluationByCodeResponse|bool
     */
    public function GetEvaluationByCode(\StructType\GetEvaluationByCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEvaluationByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMarksBySession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMarksBySession $parameters
     * @return \StructType\GetMarksBySessionResponse|bool
     */
    public function GetMarksBySession(\StructType\GetMarksBySession $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMarksBySession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMarksBySessionAssessment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMarksBySessionAssessment $parameters
     * @return \StructType\GetMarksBySessionAssessmentResponse|bool
     */
    public function GetMarksBySessionAssessment(\StructType\GetMarksBySessionAssessment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMarksBySessionAssessment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMarksBySessionAssessmentStudent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMarksBySessionAssessmentStudent $parameters
     * @return \StructType\GetMarksBySessionAssessmentStudentResponse|bool
     */
    public function GetMarksBySessionAssessmentStudent(\StructType\GetMarksBySessionAssessmentStudent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMarksBySessionAssessmentStudent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMarksByStudent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMarksByStudent $parameters
     * @return \StructType\GetMarksByStudentResponse|bool
     */
    public function GetMarksByStudent(\StructType\GetMarksByStudent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMarksByStudent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMarksByStudentSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMarksByStudentSession $parameters
     * @return \StructType\GetMarksByStudentSessionResponse|bool
     */
    public function GetMarksByStudentSession(\StructType\GetMarksByStudentSession $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMarksByStudentSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMarksByStudentSessionAssessment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMarksByStudentSessionAssessment $parameters
     * @return \StructType\GetMarksByStudentSessionAssessmentResponse|bool
     */
    public function GetMarksByStudentSessionAssessment(\StructType\GetMarksByStudentSessionAssessment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMarksByStudentSessionAssessment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProprietes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProprietes $parameters
     * @return \StructType\GetProprietesResponse|bool
     */
    public function getProprietes(\StructType\GetProprietes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getProprietes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProprietesXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProprietesXml $parameters
     * @return \StructType\GetProprietesXmlResponse|bool
     */
    public function getProprietesXml(\StructType\GetProprietesXml $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getProprietesXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAbsences
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAbsences $parameters
     * @return \StructType\GetAbsencesResponse|bool
     */
    public function GetAbsences(\StructType\GetAbsences $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAbsences($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAbsencesResponse|\StructType\GetDomainesResponse|\StructType\GetDomainesXmlResponse|\StructType\GetEvaluationByCodeResponse|\StructType\GetInscriptionsDifferentielResponse|\StructType\GetInscriptionsDifferentielXmlResponse|\StructType\GetInscriptionsResponse|\StructType\GetInscriptionsXmlResponse|\StructType\GetMarksBySessionAssessmentResponse|\StructType\GetMarksBySessionAssessmentStudentResponse|\StructType\GetMarksBySessionResponse|\StructType\GetMarksByStudentResponse|\StructType\GetMarksByStudentSessionAssessmentResponse|\StructType\GetMarksByStudentSessionResponse|\StructType\GetModuleResponse|\StructType\GetModuleXmlResponse|\StructType\GetOffreResponse|\StructType\GetOffreXmlResponse|\StructType\GetProprietesResponse|\StructType\GetProprietesXmlResponse|\StructType\GetSessionByCodeResponse|\StructType\GetSessionByCodeXmlResponse|\StructType\GetSessionResponse|\StructType\GetSessionsDifferentielResponse|\StructType\GetSessionsDifferentielXMLResponse|\StructType\GetSessionXmlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
