<?php

namespace EnumType;

/**
 * This class stands for ProcessRepercussionResult EnumType
 * @subpackage Enumerations
 */
class ProcessRepercussionResult
{
    /**
     * Constant for value 'Updated'
     * @return string 'Updated'
     */
    const VALUE_UPDATED = 'Updated';
    /**
     * Constant for value 'Created'
     * @return string 'Created'
     */
    const VALUE_CREATED = 'Created';
    /**
     * Constant for value 'NotPerHour'
     * @return string 'NotPerHour'
     */
    const VALUE_NOT_PER_HOUR = 'NotPerHour';
    /**
     * Constant for value 'PresenceValidated'
     * @return string 'PresenceValidated'
     */
    const VALUE_PRESENCE_VALIDATED = 'PresenceValidated';
    /**
     * Constant for value 'NoBatchFound'
     * @return string 'NoBatchFound'
     */
    const VALUE_NO_BATCH_FOUND = 'NoBatchFound';
    /**
     * Constant for value 'EnrollmentStateInvalid'
     * @return string 'EnrollmentStateInvalid'
     */
    const VALUE_ENROLLMENT_STATE_INVALID = 'EnrollmentStateInvalid';
    /**
     * Constant for value 'SessionStateTerminated'
     * @return string 'SessionStateTerminated'
     */
    const VALUE_SESSION_STATE_TERMINATED = 'SessionStateTerminated';
    /**
     * Constant for value 'NoNonValidatedBatchFound'
     * @return string 'NoNonValidatedBatchFound'
     */
    const VALUE_NO_NON_VALIDATED_BATCH_FOUND = 'NoNonValidatedBatchFound';
    /**
     * Constant for value 'AbsenceAttested'
     * @return string 'AbsenceAttested'
     */
    const VALUE_ABSENCE_ATTESTED = 'AbsenceAttested';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UPDATED
     * @uses self::VALUE_CREATED
     * @uses self::VALUE_NOT_PER_HOUR
     * @uses self::VALUE_PRESENCE_VALIDATED
     * @uses self::VALUE_NO_BATCH_FOUND
     * @uses self::VALUE_ENROLLMENT_STATE_INVALID
     * @uses self::VALUE_SESSION_STATE_TERMINATED
     * @uses self::VALUE_NO_NON_VALIDATED_BATCH_FOUND
     * @uses self::VALUE_ABSENCE_ATTESTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UPDATED,
            self::VALUE_CREATED,
            self::VALUE_NOT_PER_HOUR,
            self::VALUE_PRESENCE_VALIDATED,
            self::VALUE_NO_BATCH_FOUND,
            self::VALUE_ENROLLMENT_STATE_INVALID,
            self::VALUE_SESSION_STATE_TERMINATED,
            self::VALUE_NO_NON_VALIDATED_BATCH_FOUND,
            self::VALUE_ABSENCE_ATTESTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
