<?php

namespace EnumType;

/**
 * This class stands for ModesInscriptions EnumType
 * @subpackage Enumerations
 */
class ModesInscriptions
{
    /**
     * Constant for value 'INTER'
     * @return string 'INTER'
     */
    const VALUE_INTER = 'INTER';
    /**
     * Constant for value 'INDIV'
     * @return string 'INDIV'
     */
    const VALUE_INDIV = 'INDIV';
    /**
     * Constant for value 'NNTER'
     * @return string 'NNTER'
     */
    const VALUE_NNTER = 'NNTER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INTER
     * @uses self::VALUE_INDIV
     * @uses self::VALUE_NNTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INTER,
            self::VALUE_INDIV,
            self::VALUE_NNTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
