<?php

namespace EnumType;

/**
 * This class stands for AbsenceRejectedType EnumType
 * @subpackage Enumerations
 */
class AbsenceRejectedType
{
    /**
     * Constant for value 'AlreadyExist'
     * @return string 'AlreadyExist'
     */
    const VALUE_ALREADY_EXIST = 'AlreadyExist';
    /**
     * Constant for value 'AbsenceConfirmed'
     * @return string 'AbsenceConfirmed'
     */
    const VALUE_ABSENCE_CONFIRMED = 'AbsenceConfirmed';
    /**
     * Constant for value 'AbsenceAttested'
     * @return string 'AbsenceAttested'
     */
    const VALUE_ABSENCE_ATTESTED = 'AbsenceAttested';
    /**
     * Constant for value 'MultipleAbsForOneDate'
     * @return string 'MultipleAbsForOneDate'
     */
    const VALUE_MULTIPLE_ABS_FOR_ONE_DATE = 'MultipleAbsForOneDate';
    /**
     * Constant for value 'NotSessionTrainee'
     * @return string 'NotSessionTrainee'
     */
    const VALUE_NOT_SESSION_TRAINEE = 'NotSessionTrainee';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALREADY_EXIST
     * @uses self::VALUE_ABSENCE_CONFIRMED
     * @uses self::VALUE_ABSENCE_ATTESTED
     * @uses self::VALUE_MULTIPLE_ABS_FOR_ONE_DATE
     * @uses self::VALUE_NOT_SESSION_TRAINEE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALREADY_EXIST,
            self::VALUE_ABSENCE_CONFIRMED,
            self::VALUE_ABSENCE_ATTESTED,
            self::VALUE_MULTIPLE_ABS_FOR_ONE_DATE,
            self::VALUE_NOT_SESSION_TRAINEE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
