<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseBase StructType
 * @subpackage Structs
 */
abstract class ResponseBase extends AbstractStructBase
{
    /**
     * The ResponseTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResponseTime;
    /**
     * Constructor method for ResponseBase
     * @uses ResponseBase::setResponseTime()
     * @param string $responseTime
     */
    public function __construct($responseTime = null)
    {
        $this
            ->setResponseTime($responseTime);
    }
    /**
     * Get ResponseTime value
     * @return string
     */
    public function getResponseTime()
    {
        return $this->ResponseTime;
    }
    /**
     * Set ResponseTime value
     * @param string $responseTime
     * @return \StructType\ResponseBase
     */
    public function setResponseTime($responseTime = null)
    {
        // validation for constraint: string
        if (!is_null($responseTime) && !is_string($responseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseTime)), __LINE__);
        }
        $this->ResponseTime = $responseTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
