<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintoutRequest StructType
 * @subpackage Structs
 */
class PrintoutRequest extends AbstractStructBase
{
    /**
     * The PrinterFriendly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PrinterFriendly;
    /**
     * The SearchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SearchId;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * Constructor method for PrintoutRequest
     * @uses PrintoutRequest::setPrinterFriendly()
     * @uses PrintoutRequest::setSearchId()
     * @uses PrintoutRequest::setType()
     * @param bool $printerFriendly
     * @param int $searchId
     * @param string $type
     */
    public function __construct($printerFriendly = null, $searchId = null, $type = null)
    {
        $this
            ->setPrinterFriendly($printerFriendly)
            ->setSearchId($searchId)
            ->setType($type);
    }
    /**
     * Get PrinterFriendly value
     * @return bool
     */
    public function getPrinterFriendly()
    {
        return $this->PrinterFriendly;
    }
    /**
     * Set PrinterFriendly value
     * @param bool $printerFriendly
     * @return \StructType\PrintoutRequest
     */
    public function setPrinterFriendly($printerFriendly = null)
    {
        // validation for constraint: boolean
        if (!is_null($printerFriendly) && !is_bool($printerFriendly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($printerFriendly)), __LINE__);
        }
        $this->PrinterFriendly = $printerFriendly;
        return $this;
    }
    /**
     * Get SearchId value
     * @return int
     */
    public function getSearchId()
    {
        return $this->SearchId;
    }
    /**
     * Set SearchId value
     * @param int $searchId
     * @return \StructType\PrintoutRequest
     */
    public function setSearchId($searchId = null)
    {
        // validation for constraint: int
        if (!is_null($searchId) && !is_numeric($searchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($searchId)), __LINE__);
        }
        $this->SearchId = $searchId;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\PrintoutType::valueIsValid()
     * @uses \EnumType\PrintoutType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\PrintoutRequest
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintoutType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\PrintoutType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrintoutRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
