<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintoutImage StructType
 * @subpackage Structs
 */
class PrintoutImage extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The ImageData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageData;
    /**
     * Constructor method for PrintoutImage
     * @uses PrintoutImage::setName()
     * @uses PrintoutImage::setImageData()
     * @param string $name
     * @param string $imageData
     */
    public function __construct($name = null, $imageData = null)
    {
        $this
            ->setName($name)
            ->setImageData($imageData);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PrintoutImage
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ImageData value
     * @return string|null
     */
    public function getImageData()
    {
        return $this->ImageData;
    }
    /**
     * Set ImageData value
     * @param string $imageData
     * @return \StructType\PrintoutImage
     */
    public function setImageData($imageData = null)
    {
        // validation for constraint: string
        if (!is_null($imageData) && !is_string($imageData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageData)), __LINE__);
        }
        $this->ImageData = $imageData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrintoutImage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
