<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EulaResponse StructType
 * @subpackage Structs
 */
class EulaResponse extends ResponseBase
{
    /**
     * The Eula
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Eula;
    /**
     * The EulaMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EulaMessage;
    /**
     * Constructor method for EulaResponse
     * @uses EulaResponse::setEula()
     * @uses EulaResponse::setEulaMessage()
     * @param string $eula
     * @param string $eulaMessage
     */
    public function __construct($eula = null, $eulaMessage = null)
    {
        $this
            ->setEula($eula)
            ->setEulaMessage($eulaMessage);
    }
    /**
     * Get Eula value
     * @return string
     */
    public function getEula()
    {
        return $this->Eula;
    }
    /**
     * Set Eula value
     * @uses \EnumType\Eula::valueIsValid()
     * @uses \EnumType\Eula::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eula
     * @return \StructType\EulaResponse
     */
    public function setEula($eula = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Eula::valueIsValid($eula)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eula, implode(', ', \EnumType\Eula::getValidValues())), __LINE__);
        }
        $this->Eula = $eula;
        return $this;
    }
    /**
     * Get EulaMessage value
     * @return string|null
     */
    public function getEulaMessage()
    {
        return $this->EulaMessage;
    }
    /**
     * Set EulaMessage value
     * @param string $eulaMessage
     * @return \StructType\EulaResponse
     */
    public function setEulaMessage($eulaMessage = null)
    {
        // validation for constraint: string
        if (!is_null($eulaMessage) && !is_string($eulaMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eulaMessage)), __LINE__);
        }
        $this->EulaMessage = $eulaMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EulaResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
