<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyByRegistrationNumberRequest StructType
 * @subpackage Structs
 */
class CompanyByRegistrationNumberRequest extends CompanyRequest
{
    /**
     * The RegistrationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationNumber;
    /**
     * Constructor method for CompanyByRegistrationNumberRequest
     * @uses CompanyByRegistrationNumberRequest::setRegistrationNumber()
     * @param string $registrationNumber
     */
    public function __construct($registrationNumber = null)
    {
        $this
            ->setRegistrationNumber($registrationNumber);
    }
    /**
     * Get RegistrationNumber value
     * @return string|null
     */
    public function getRegistrationNumber()
    {
        return $this->RegistrationNumber;
    }
    /**
     * Set RegistrationNumber value
     * @param string $registrationNumber
     * @return \StructType\CompanyByRegistrationNumberRequest
     */
    public function setRegistrationNumber($registrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($registrationNumber) && !is_string($registrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationNumber)), __LINE__);
        }
        $this->RegistrationNumber = $registrationNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyByRegistrationNumberRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
