<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckCredentialsResponse StructType
 * @subpackage Structs
 */
class CheckCredentialsResponse extends AbstractStructBase
{
    /**
     * The CheckCredentialsResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CheckCredentialsResult;
    /**
     * Constructor method for CheckCredentialsResponse
     * @uses CheckCredentialsResponse::setCheckCredentialsResult()
     * @param string $checkCredentialsResult
     */
    public function __construct($checkCredentialsResult = null)
    {
        $this
            ->setCheckCredentialsResult($checkCredentialsResult);
    }
    /**
     * Get CheckCredentialsResult value
     * @return string
     */
    public function getCheckCredentialsResult()
    {
        return $this->CheckCredentialsResult;
    }
    /**
     * Set CheckCredentialsResult value
     * @uses \EnumType\LoginStatus::valueIsValid()
     * @uses \EnumType\LoginStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $checkCredentialsResult
     * @return \StructType\CheckCredentialsResponse
     */
    public function setCheckCredentialsResult($checkCredentialsResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LoginStatus::valueIsValid($checkCredentialsResult)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $checkCredentialsResult, implode(', ', \EnumType\LoginStatus::getValidValues())), __LINE__);
        }
        $this->CheckCredentialsResult = $checkCredentialsResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckCredentialsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
