<?php

namespace EnumType;

/**
 * This class stands for RequestType EnumType
 * @subpackage Enumerations
 */
class RequestType
{
    /**
     * Constant for value 'DOPersonSearch'
     * @return string 'DOPersonSearch'
     */
    const VALUE_DOPERSON_SEARCH = 'DOPersonSearch';
    /**
     * Constant for value 'DOPropertySearch'
     * @return string 'DOPropertySearch'
     */
    const VALUE_DOPROPERTY_SEARCH = 'DOPropertySearch';
    /**
     * Constant for value 'DODocumentSearch'
     * @return string 'DODocumentSearch'
     */
    const VALUE_DODOCUMENT_SEARCH = 'DODocumentSearch';
    /**
     * Constant for value 'DODocumentRequest'
     * @return string 'DODocumentRequest'
     */
    const VALUE_DODOCUMENT_REQUEST = 'DODocumentRequest';
    /**
     * Constant for value 'DOFarmLookup'
     * @return string 'DOFarmLookup'
     */
    const VALUE_DOFARM_LOOKUP = 'DOFarmLookup';
    /**
     * Constant for value 'DOInterdictSearch'
     * @return string 'DOInterdictSearch'
     */
    const VALUE_DOINTERDICT_SEARCH = 'DOInterdictSearch';
    /**
     * Constant for value 'DOTransferDetails'
     * @return string 'DOTransferDetails'
     */
    const VALUE_DOTRANSFER_DETAILS = 'DOTransferDetails';
    /**
     * Constant for value 'DOTransferOverview'
     * @return string 'DOTransferOverview'
     */
    const VALUE_DOTRANSFER_OVERVIEW = 'DOTransferOverview';
    /**
     * Constant for value 'UnknownRequest'
     * @return string 'UnknownRequest'
     */
    const VALUE_UNKNOWN_REQUEST = 'UnknownRequest';
    /**
     * Constant for value 'PassthroughSearch'
     * @return string 'PassthroughSearch'
     */
    const VALUE_PASSTHROUGH_SEARCH = 'PassthroughSearch';
    /**
     * Constant for value 'DOPropertyListSearch'
     * @return string 'DOPropertyListSearch'
     */
    const VALUE_DOPROPERTY_LIST_SEARCH = 'DOPropertyListSearch';
    /**
     * Constant for value 'TUITCConsumerProfile'
     * @return string 'TUITCConsumerProfile'
     */
    const VALUE_TUITCCONSUMER_PROFILE = 'TUITCConsumerProfile';
    /**
     * Constant for value 'TUITCPrincipalLink'
     * @return string 'TUITCPrincipalLink'
     */
    const VALUE_TUITCPRINCIPAL_LINK = 'TUITCPrincipalLink';
    /**
     * Constant for value 'TUITCBusinessProfile'
     * @return string 'TUITCBusinessProfile'
     */
    const VALUE_TUITCBUSINESS_PROFILE = 'TUITCBusinessProfile';
    /**
     * Constant for value 'TUITCIDVerification'
     * @return string 'TUITCIDVerification'
     */
    const VALUE_TUITCIDVERIFICATION = 'TUITCIDVerification';
    /**
     * Constant for value 'TUITCSkipTraceIndividual'
     * @return string 'TUITCSkipTraceIndividual'
     */
    const VALUE_TUITCSKIP_TRACE_INDIVIDUAL = 'TUITCSkipTraceIndividual';
    /**
     * Constant for value 'TUITCAssetSearchIndividual'
     * @return string 'TUITCAssetSearchIndividual'
     */
    const VALUE_TUITCASSET_SEARCH_INDIVIDUAL = 'TUITCAssetSearchIndividual';
    /**
     * Constant for value 'TUITCIntSkipTraceIndividual'
     * @return string 'TUITCIntSkipTraceIndividual'
     */
    const VALUE_TUITCINT_SKIP_TRACE_INDIVIDUAL = 'TUITCIntSkipTraceIndividual';
    /**
     * Constant for value 'TUITCSkipTraceCompany'
     * @return string 'TUITCSkipTraceCompany'
     */
    const VALUE_TUITCSKIP_TRACE_COMPANY = 'TUITCSkipTraceCompany';
    /**
     * Constant for value 'TUITCAssetSearchCompany'
     * @return string 'TUITCAssetSearchCompany'
     */
    const VALUE_TUITCASSET_SEARCH_COMPANY = 'TUITCAssetSearchCompany';
    /**
     * Constant for value 'TUITCIntSkipTraceCompany'
     * @return string 'TUITCIntSkipTraceCompany'
     */
    const VALUE_TUITCINT_SKIP_TRACE_COMPANY = 'TUITCIntSkipTraceCompany';
    /**
     * Constant for value 'TUITCEmploymentVerification'
     * @return string 'TUITCEmploymentVerification'
     */
    const VALUE_TUITCEMPLOYMENT_VERIFICATION = 'TUITCEmploymentVerification';
    /**
     * Constant for value 'ChequeVerification'
     * @return string 'ChequeVerification'
     */
    const VALUE_CHEQUE_VERIFICATION = 'ChequeVerification';
    /**
     * Constant for value 'CIPROCompanySearch'
     * @return string 'CIPROCompanySearch'
     */
    const VALUE_CIPROCOMPANY_SEARCH = 'CIPROCompanySearch';
    /**
     * Constant for value 'CIPRODirectorSearch'
     * @return string 'CIPRODirectorSearch'
     */
    const VALUE_CIPRODIRECTOR_SEARCH = 'CIPRODirectorSearch';
    /**
     * Constant for value 'SGDiagramRequest'
     * @return string 'SGDiagramRequest'
     */
    const VALUE_SGDIAGRAM_REQUEST = 'SGDiagramRequest';
    /**
     * Constant for value 'StreettoErfConversion'
     * @return string 'StreettoErfConversion'
     */
    const VALUE_STREETTO_ERF_CONVERSION = 'StreettoErfConversion';
    /**
     * Constant for value 'ErftoStreetConversion'
     * @return string 'ErftoStreetConversion'
     */
    const VALUE_ERFTO_STREET_CONVERSION = 'ErftoStreetConversion';
    /**
     * Constant for value 'SchemeConversion'
     * @return string 'SchemeConversion'
     */
    const VALUE_SCHEME_CONVERSION = 'SchemeConversion';
    /**
     * Constant for value 'CAVPropertyValuationOption1'
     * @return string 'CAVPropertyValuationOption1'
     */
    const VALUE_CAVPROPERTY_VALUATION_OPTION_1 = 'CAVPropertyValuationOption1';
    /**
     * Constant for value 'CAVPropertyValuationOption2'
     * @return string 'CAVPropertyValuationOption2'
     */
    const VALUE_CAVPROPERTY_VALUATION_OPTION_2 = 'CAVPropertyValuationOption2';
    /**
     * Constant for value 'CAVPropertyValuationOption3'
     * @return string 'CAVPropertyValuationOption3'
     */
    const VALUE_CAVPROPERTY_VALUATION_OPTION_3 = 'CAVPropertyValuationOption3';
    /**
     * Constant for value 'HistoricalTransferSuburbRDList'
     * @return string 'HistoricalTransferSuburbRDList'
     */
    const VALUE_HISTORICAL_TRANSFER_SUBURB_RDLIST = 'HistoricalTransferSuburbRDList';
    /**
     * Constant for value 'HistoricalTransferOverview'
     * @return string 'HistoricalTransferOverview'
     */
    const VALUE_HISTORICAL_TRANSFER_OVERVIEW = 'HistoricalTransferOverview';
    /**
     * Constant for value 'HistoricalTransferDetails'
     * @return string 'HistoricalTransferDetails'
     */
    const VALUE_HISTORICAL_TRANSFER_DETAILS = 'HistoricalTransferDetails';
    /**
     * Constant for value 'KorbitecStreetToErfConversion'
     * @return string 'KorbitecStreetToErfConversion'
     */
    const VALUE_KORBITEC_STREET_TO_ERF_CONVERSION = 'KorbitecStreetToErfConversion';
    /**
     * Constant for value 'KorbitecErfToStreetConversion'
     * @return string 'KorbitecErfToStreetConversion'
     */
    const VALUE_KORBITEC_ERF_TO_STREET_CONVERSION = 'KorbitecErfToStreetConversion';
    /**
     * Constant for value 'sas'
     * @return string 'sas'
     */
    const VALUE_SAS = 'sas';
    /**
     * Constant for value 'GISCOE'
     * @return string 'GISCOE'
     */
    const VALUE_GISCOE = 'GISCOE';
    /**
     * Constant for value 'DocRequests'
     * @return string 'DocRequests'
     */
    const VALUE_DOC_REQUESTS = 'DocRequests';
    /**
     * Constant for value 'OfflinePersonSearch'
     * @return string 'OfflinePersonSearch'
     */
    const VALUE_OFFLINE_PERSON_SEARCH = 'OfflinePersonSearch';
    /**
     * Constant for value 'OfflinePropertySearch'
     * @return string 'OfflinePropertySearch'
     */
    const VALUE_OFFLINE_PROPERTY_SEARCH = 'OfflinePropertySearch';
    /**
     * Constant for value 'OfflineDocumentSearch'
     * @return string 'OfflineDocumentSearch'
     */
    const VALUE_OFFLINE_DOCUMENT_SEARCH = 'OfflineDocumentSearch';
    /**
     * Constant for value 'OfflineInterdictSearch'
     * @return string 'OfflineInterdictSearch'
     */
    const VALUE_OFFLINE_INTERDICT_SEARCH = 'OfflineInterdictSearch';
    /**
     * Constant for value 'OfflineMultiProperty'
     * @return string 'OfflineMultiProperty'
     */
    const VALUE_OFFLINE_MULTI_PROPERTY = 'OfflineMultiProperty';
    /**
     * Constant for value 'OfflineNotificationSMS'
     * @return string 'OfflineNotificationSMS'
     */
    const VALUE_OFFLINE_NOTIFICATION_SMS = 'OfflineNotificationSMS';
    /**
     * Constant for value 'SpiderSearch'
     * @return string 'SpiderSearch'
     */
    const VALUE_SPIDER_SEARCH = 'SpiderSearch';
    /**
     * Constant for value 'AutomatedValuationFull'
     * @return string 'AutomatedValuationFull'
     */
    const VALUE_AUTOMATED_VALUATION_FULL = 'AutomatedValuationFull';
    /**
     * Constant for value 'AutomatedValuationShort'
     * @return string 'AutomatedValuationShort'
     */
    const VALUE_AUTOMATED_VALUATION_SHORT = 'AutomatedValuationShort';
    /**
     * Constant for value 'ContactInformation'
     * @return string 'ContactInformation'
     */
    const VALUE_CONTACT_INFORMATION = 'ContactInformation';
    /**
     * Constant for value 'DOPropertySearchFootprint'
     * @return string 'DOPropertySearchFootprint'
     */
    const VALUE_DOPROPERTY_SEARCH_FOOTPRINT = 'DOPropertySearchFootprint';
    /**
     * Constant for value 'BFASANumberSearch'
     * @return string 'BFASANumberSearch'
     */
    const VALUE_BFASANUMBER_SEARCH = 'BFASANumberSearch';
    /**
     * Constant for value 'DODocumentTextVersion'
     * @return string 'DODocumentTextVersion'
     */
    const VALUE_DODOCUMENT_TEXT_VERSION = 'DODocumentTextVersion';
    /**
     * Constant for value 'DOTSSearch'
     * @return string 'DOTSSearch'
     */
    const VALUE_DOTSSEARCH = 'DOTSSearch';
    /**
     * Constant for value 'AutomatedTracking'
     * @return string 'AutomatedTracking'
     */
    const VALUE_AUTOMATED_TRACKING = 'AutomatedTracking';
    /**
     * Constant for value 'AdCheckAddress'
     * @return string 'AdCheckAddress'
     */
    const VALUE_AD_CHECK_ADDRESS = 'AdCheckAddress';
    /**
     * Constant for value 'AdCheckReport'
     * @return string 'AdCheckReport'
     */
    const VALUE_AD_CHECK_REPORT = 'AdCheckReport';
    /**
     * Constant for value 'TransferInstruction'
     * @return string 'TransferInstruction'
     */
    const VALUE_TRANSFER_INSTRUCTION = 'TransferInstruction';
    /**
     * Constant for value 'TransferInstructionNotificationSMS'
     * @return string 'TransferInstructionNotificationSMS'
     */
    const VALUE_TRANSFER_INSTRUCTION_NOTIFICATION_SMS = 'TransferInstructionNotificationSMS';
    /**
     * Constant for value 'DeedofSale'
     * @return string 'DeedofSale'
     */
    const VALUE_DEEDOF_SALE = 'DeedofSale';
    /**
     * Constant for value 'TransferInstructionAmendment'
     * @return string 'TransferInstructionAmendment'
     */
    const VALUE_TRANSFER_INSTRUCTION_AMENDMENT = 'TransferInstructionAmendment';
    /**
     * Constant for value 'ExperianConsumerProfile'
     * @return string 'ExperianConsumerProfile'
     */
    const VALUE_EXPERIAN_CONSUMER_PROFILE = 'ExperianConsumerProfile';
    /**
     * Constant for value 'WatchRequest'
     * @return string 'WatchRequest'
     */
    const VALUE_WATCH_REQUEST = 'WatchRequest';
    /**
     * Constant for value 'WatchNotificationDeactivationRequest'
     * @return string 'WatchNotificationDeactivationRequest'
     */
    const VALUE_WATCH_NOTIFICATION_DEACTIVATION_REQUEST = 'WatchNotificationDeactivationRequest';
    /**
     * Constant for value 'WatchNotificationActivationRequest'
     * @return string 'WatchNotificationActivationRequest'
     */
    const VALUE_WATCH_NOTIFICATION_ACTIVATION_REQUEST = 'WatchNotificationActivationRequest';
    /**
     * Constant for value 'WatchDeactivationRequest'
     * @return string 'WatchDeactivationRequest'
     */
    const VALUE_WATCH_DEACTIVATION_REQUEST = 'WatchDeactivationRequest';
    /**
     * Constant for value 'WatchActivationRequest'
     * @return string 'WatchActivationRequest'
     */
    const VALUE_WATCH_ACTIVATION_REQUEST = 'WatchActivationRequest';
    /**
     * Constant for value 'WatchPrescribedPurposeRequest'
     * @return string 'WatchPrescribedPurposeRequest'
     */
    const VALUE_WATCH_PRESCRIBED_PURPOSE_REQUEST = 'WatchPrescribedPurposeRequest';
    /**
     * Constant for value 'WatchDeletionRequest'
     * @return string 'WatchDeletionRequest'
     */
    const VALUE_WATCH_DELETION_REQUEST = 'WatchDeletionRequest';
    /**
     * Constant for value 'PropIQ'
     * @return string 'PropIQ'
     */
    const VALUE_PROP_IQ = 'PropIQ';
    /**
     * Constant for value 'MultiDOPersonSearch'
     * @return string 'MultiDOPersonSearch'
     */
    const VALUE_MULTI_DOPERSON_SEARCH = 'MultiDOPersonSearch';
    /**
     * Constant for value 'Objections'
     * @return string 'Objections'
     */
    const VALUE_OBJECTIONS = 'Objections';
    /**
     * Constant for value 'AfriGIS'
     * @return string 'AfriGIS'
     */
    const VALUE_AFRI_GIS = 'AfriGIS';
    /**
     * Constant for value 'WinDeedPropertySearch'
     * @return string 'WinDeedPropertySearch'
     */
    const VALUE_WIN_DEED_PROPERTY_SEARCH = 'WinDeedPropertySearch';
    /**
     * Constant for value 'WinDeedFarmLookup'
     * @return string 'WinDeedFarmLookup'
     */
    const VALUE_WIN_DEED_FARM_LOOKUP = 'WinDeedFarmLookup';
    /**
     * Constant for value 'TPNCompany'
     * @return string 'TPNCompany'
     */
    const VALUE_TPNCOMPANY = 'TPNCompany';
    /**
     * Constant for value 'TPNConsumer'
     * @return string 'TPNConsumer'
     */
    const VALUE_TPNCONSUMER = 'TPNConsumer';
    /**
     * Constant for value 'TPNPrescribedPurpose'
     * @return string 'TPNPrescribedPurpose'
     */
    const VALUE_TPNPRESCRIBED_PURPOSE = 'TPNPrescribedPurpose';
    /**
     * Constant for value 'WinDeedSuburbReport'
     * @return string 'WinDeedSuburbReport'
     */
    const VALUE_WIN_DEED_SUBURB_REPORT = 'WinDeedSuburbReport';
    /**
     * Constant for value 'WinDeedPropertyAdvancedSearch'
     * @return string 'WinDeedPropertyAdvancedSearch'
     */
    const VALUE_WIN_DEED_PROPERTY_ADVANCED_SEARCH = 'WinDeedPropertyAdvancedSearch';
    /**
     * Constant for value 'JudgmentEnquiryCompany'
     * @return string 'JudgmentEnquiryCompany'
     */
    const VALUE_JUDGMENT_ENQUIRY_COMPANY = 'JudgmentEnquiryCompany';
    /**
     * Constant for value 'JudgmentEnquiryIndividual'
     * @return string 'JudgmentEnquiryIndividual'
     */
    const VALUE_JUDGMENT_ENQUIRY_INDIVIDUAL = 'JudgmentEnquiryIndividual';
    /**
     * Constant for value 'JudgmentEnquiryDocumentCopy'
     * @return string 'JudgmentEnquiryDocumentCopy'
     */
    const VALUE_JUDGMENT_ENQUIRY_DOCUMENT_COPY = 'JudgmentEnquiryDocumentCopy';
    /**
     * Constant for value 'TraceEnquiry'
     * @return string 'TraceEnquiry'
     */
    const VALUE_TRACE_ENQUIRY = 'TraceEnquiry';
    /**
     * Constant for value 'TUITCTraceEnquiry'
     * @return string 'TUITCTraceEnquiry'
     */
    const VALUE_TUITCTRACE_ENQUIRY = 'TUITCTraceEnquiry';
    /**
     * Constant for value 'VehicleSearch'
     * @return string 'VehicleSearch'
     */
    const VALUE_VEHICLE_SEARCH = 'VehicleSearch';
    /**
     * Constant for value 'CipcUberCompanySearch'
     * @return string 'CipcUberCompanySearch'
     */
    const VALUE_CIPC_UBER_COMPANY_SEARCH = 'CipcUberCompanySearch';
    /**
     * Constant for value 'CipcUberDirectorSearch'
     * @return string 'CipcUberDirectorSearch'
     */
    const VALUE_CIPC_UBER_DIRECTOR_SEARCH = 'CipcUberDirectorSearch';
    /**
     * Constant for value 'CompuscanTrace'
     * @return string 'CompuscanTrace'
     */
    const VALUE_COMPUSCAN_TRACE = 'CompuscanTrace';
    /**
     * Constant for value 'CompuscanTracePrescribedPurpose'
     * @return string 'CompuscanTracePrescribedPurpose'
     */
    const VALUE_COMPUSCAN_TRACE_PRESCRIBED_PURPOSE = 'CompuscanTracePrescribedPurpose';
    /**
     * Constant for value 'TransUnionAlerts'
     * @return string 'TransUnionAlerts'
     */
    const VALUE_TRANS_UNION_ALERTS = 'TransUnionAlerts';
    /**
     * Constant for value 'TransUnionVehicleEnquiry'
     * @return string 'TransUnionVehicleEnquiry'
     */
    const VALUE_TRANS_UNION_VEHICLE_ENQUIRY = 'TransUnionVehicleEnquiry';
    /**
     * Constant for value 'CompuscanConsumerProfile'
     * @return string 'CompuscanConsumerProfile'
     */
    const VALUE_COMPUSCAN_CONSUMER_PROFILE = 'CompuscanConsumerProfile';
    /**
     * Constant for value 'CompuscanConsumerProfilePrescribedPurpose'
     * @return string 'CompuscanConsumerProfilePrescribedPurpose'
     */
    const VALUE_COMPUSCAN_CONSUMER_PROFILE_PRESCRIBED_PURPOSE = 'CompuscanConsumerProfilePrescribedPurpose';
    /**
     * Constant for value 'DeedsOfficePropertyBatchSearch'
     * @return string 'DeedsOfficePropertyBatchSearch'
     */
    const VALUE_DEEDS_OFFICE_PROPERTY_BATCH_SEARCH = 'DeedsOfficePropertyBatchSearch';
    /**
     * Constant for value 'DeedsOfficePersonBatchSearch'
     * @return string 'DeedsOfficePersonBatchSearch'
     */
    const VALUE_DEEDS_OFFICE_PERSON_BATCH_SEARCH = 'DeedsOfficePersonBatchSearch';
    /**
     * Constant for value 'DataServicesOfflinePersonSearch'
     * @return string 'DataServicesOfflinePersonSearch'
     */
    const VALUE_DATA_SERVICES_OFFLINE_PERSON_SEARCH = 'DataServicesOfflinePersonSearch';
    /**
     * Constant for value 'DataServicesOfflinePropertySearch'
     * @return string 'DataServicesOfflinePropertySearch'
     */
    const VALUE_DATA_SERVICES_OFFLINE_PROPERTY_SEARCH = 'DataServicesOfflinePropertySearch';
    /**
     * Constant for value 'DataServicesOfflineDocumentSearch'
     * @return string 'DataServicesOfflineDocumentSearch'
     */
    const VALUE_DATA_SERVICES_OFFLINE_DOCUMENT_SEARCH = 'DataServicesOfflineDocumentSearch';
    /**
     * Constant for value 'DataServicesOfflineInterdictSearch'
     * @return string 'DataServicesOfflineInterdictSearch'
     */
    const VALUE_DATA_SERVICES_OFFLINE_INTERDICT_SEARCH = 'DataServicesOfflineInterdictSearch';
    /**
     * Constant for value 'DataServicesOfflineMultiProperty'
     * @return string 'DataServicesOfflineMultiProperty'
     */
    const VALUE_DATA_SERVICES_OFFLINE_MULTI_PROPERTY = 'DataServicesOfflineMultiProperty';
    /**
     * Constant for value 'AgentIQ'
     * @return string 'AgentIQ'
     */
    const VALUE_AGENT_IQ = 'AgentIQ';
    /**
     * Constant for value 'DataServicesSpiderSearch'
     * @return string 'DataServicesSpiderSearch'
     */
    const VALUE_DATA_SERVICES_SPIDER_SEARCH = 'DataServicesSpiderSearch';
    /**
     * Constant for value 'OfflinePropertyV1'
     * @return string 'OfflinePropertyV1'
     */
    const VALUE_OFFLINE_PROPERTY_V_1 = 'OfflinePropertyV1';
    /**
     * Constant for value 'WinDeedDatabasePropertyV1'
     * @return string 'WinDeedDatabasePropertyV1'
     */
    const VALUE_WIN_DEED_DATABASE_PROPERTY_V_1 = 'WinDeedDatabasePropertyV1';
    /**
     * Constant for value 'AktexPropertyV1'
     * @return string 'AktexPropertyV1'
     */
    const VALUE_AKTEX_PROPERTY_V_1 = 'AktexPropertyV1';
    /**
     * Constant for value 'DeedsWebPropertyV1'
     * @return string 'DeedsWebPropertyV1'
     */
    const VALUE_DEEDS_WEB_PROPERTY_V_1 = 'DeedsWebPropertyV1';
    /**
     * Constant for value 'XDSTrace'
     * @return string 'XDSTrace'
     */
    const VALUE_XDSTRACE = 'XDSTrace';
    /**
     * Constant for value 'XDSConsumerTrace'
     * @return string 'XDSConsumerTrace'
     */
    const VALUE_XDSCONSUMER_TRACE = 'XDSConsumerTrace';
    /**
     * Constant for value 'XDSConsumerProfile'
     * @return string 'XDSConsumerProfile'
     */
    const VALUE_XDSCONSUMER_PROFILE = 'XDSConsumerProfile';
    /**
     * Constant for value 'HomeAffairsIDV'
     * @return string 'HomeAffairsIDV'
     */
    const VALUE_HOME_AFFAIRS_IDV = 'HomeAffairsIDV';
    /**
     * Constant for value 'EnatisVehicleHistory'
     * @return string 'EnatisVehicleHistory'
     */
    const VALUE_ENATIS_VEHICLE_HISTORY = 'EnatisVehicleHistory';
    /**
     * Constant for value 'EnatisVehicleDetails'
     * @return string 'EnatisVehicleDetails'
     */
    const VALUE_ENATIS_VEHICLE_DETAILS = 'EnatisVehicleDetails';
    /**
     * Constant for value 'EnatisOwnerVehicles'
     * @return string 'EnatisOwnerVehicles'
     */
    const VALUE_ENATIS_OWNER_VEHICLES = 'EnatisOwnerVehicles';
    /**
     * Constant for value 'VatNumber'
     * @return string 'VatNumber'
     */
    const VALUE_VAT_NUMBER = 'VatNumber';
    /**
     * Constant for value 'DeedsWebLpiCodeV1'
     * @return string 'DeedsWebLpiCodeV1'
     */
    const VALUE_DEEDS_WEB_LPI_CODE_V_1 = 'DeedsWebLpiCodeV1';
    /**
     * Constant for value 'WinDeedDatabaseLpiCodeV1'
     * @return string 'WinDeedDatabaseLpiCodeV1'
     */
    const VALUE_WIN_DEED_DATABASE_LPI_CODE_V_1 = 'WinDeedDatabaseLpiCodeV1';
    /**
     * Constant for value 'OfflineLpiCodeV1'
     * @return string 'OfflineLpiCodeV1'
     */
    const VALUE_OFFLINE_LPI_CODE_V_1 = 'OfflineLpiCodeV1';
    /**
     * Constant for value 'WinDeedDatabaseDocumentSearchV1'
     * @return string 'WinDeedDatabaseDocumentSearchV1'
     */
    const VALUE_WIN_DEED_DATABASE_DOCUMENT_SEARCH_V_1 = 'WinDeedDatabaseDocumentSearchV1';
    /**
     * Constant for value 'BankAccountVerification'
     * @return string 'BankAccountVerification'
     */
    const VALUE_BANK_ACCOUNT_VERIFICATION = 'BankAccountVerification';
    /**
     * Constant for value 'TransUnionConsumerProfileV1'
     * @return string 'TransUnionConsumerProfileV1'
     */
    const VALUE_TRANS_UNION_CONSUMER_PROFILE_V_1 = 'TransUnionConsumerProfileV1';
    /**
     * Constant for value 'TransUnionStatutoryDetailonFile'
     * @return string 'TransUnionStatutoryDetailonFile'
     */
    const VALUE_TRANS_UNION_STATUTORY_DETAILON_FILE = 'TransUnionStatutoryDetailonFile';
    /**
     * Constant for value 'TransUnionSubjectDefault'
     * @return string 'TransUnionSubjectDefault'
     */
    const VALUE_TRANS_UNION_SUBJECT_DEFAULT = 'TransUnionSubjectDefault';
    /**
     * Constant for value 'TransUnionPrincipalDetail'
     * @return string 'TransUnionPrincipalDetail'
     */
    const VALUE_TRANS_UNION_PRINCIPAL_DETAIL = 'TransUnionPrincipalDetail';
    /**
     * Constant for value 'TransUnionEnquiryHistory'
     * @return string 'TransUnionEnquiryHistory'
     */
    const VALUE_TRANS_UNION_ENQUIRY_HISTORY = 'TransUnionEnquiryHistory';
    /**
     * Constant for value 'TransUnionBankonFile'
     * @return string 'TransUnionBankonFile'
     */
    const VALUE_TRANS_UNION_BANKON_FILE = 'TransUnionBankonFile';
    /**
     * Constant for value 'TransUnionTradeonFile'
     * @return string 'TransUnionTradeonFile'
     */
    const VALUE_TRANS_UNION_TRADEON_FILE = 'TransUnionTradeonFile';
    /**
     * Constant for value 'TransUnionDeedsonFile'
     * @return string 'TransUnionDeedsonFile'
     */
    const VALUE_TRANS_UNION_DEEDSON_FILE = 'TransUnionDeedsonFile';
    /**
     * Constant for value 'TransUnionScanonFile'
     * @return string 'TransUnionScanonFile'
     */
    const VALUE_TRANS_UNION_SCANON_FILE = 'TransUnionScanonFile';
    /**
     * Constant for value 'TransUnionDynamicRatingSMEAssessment'
     * @return string 'TransUnionDynamicRatingSMEAssessment'
     */
    const VALUE_TRANS_UNION_DYNAMIC_RATING_SMEASSESSMENT = 'TransUnionDynamicRatingSMEAssessment';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DOPERSON_SEARCH
     * @uses self::VALUE_DOPROPERTY_SEARCH
     * @uses self::VALUE_DODOCUMENT_SEARCH
     * @uses self::VALUE_DODOCUMENT_REQUEST
     * @uses self::VALUE_DOFARM_LOOKUP
     * @uses self::VALUE_DOINTERDICT_SEARCH
     * @uses self::VALUE_DOTRANSFER_DETAILS
     * @uses self::VALUE_DOTRANSFER_OVERVIEW
     * @uses self::VALUE_UNKNOWN_REQUEST
     * @uses self::VALUE_PASSTHROUGH_SEARCH
     * @uses self::VALUE_DOPROPERTY_LIST_SEARCH
     * @uses self::VALUE_TUITCCONSUMER_PROFILE
     * @uses self::VALUE_TUITCPRINCIPAL_LINK
     * @uses self::VALUE_TUITCBUSINESS_PROFILE
     * @uses self::VALUE_TUITCIDVERIFICATION
     * @uses self::VALUE_TUITCSKIP_TRACE_INDIVIDUAL
     * @uses self::VALUE_TUITCASSET_SEARCH_INDIVIDUAL
     * @uses self::VALUE_TUITCINT_SKIP_TRACE_INDIVIDUAL
     * @uses self::VALUE_TUITCSKIP_TRACE_COMPANY
     * @uses self::VALUE_TUITCASSET_SEARCH_COMPANY
     * @uses self::VALUE_TUITCINT_SKIP_TRACE_COMPANY
     * @uses self::VALUE_TUITCEMPLOYMENT_VERIFICATION
     * @uses self::VALUE_CHEQUE_VERIFICATION
     * @uses self::VALUE_CIPROCOMPANY_SEARCH
     * @uses self::VALUE_CIPRODIRECTOR_SEARCH
     * @uses self::VALUE_SGDIAGRAM_REQUEST
     * @uses self::VALUE_STREETTO_ERF_CONVERSION
     * @uses self::VALUE_ERFTO_STREET_CONVERSION
     * @uses self::VALUE_SCHEME_CONVERSION
     * @uses self::VALUE_CAVPROPERTY_VALUATION_OPTION_1
     * @uses self::VALUE_CAVPROPERTY_VALUATION_OPTION_2
     * @uses self::VALUE_CAVPROPERTY_VALUATION_OPTION_3
     * @uses self::VALUE_HISTORICAL_TRANSFER_SUBURB_RDLIST
     * @uses self::VALUE_HISTORICAL_TRANSFER_OVERVIEW
     * @uses self::VALUE_HISTORICAL_TRANSFER_DETAILS
     * @uses self::VALUE_KORBITEC_STREET_TO_ERF_CONVERSION
     * @uses self::VALUE_KORBITEC_ERF_TO_STREET_CONVERSION
     * @uses self::VALUE_SAS
     * @uses self::VALUE_GISCOE
     * @uses self::VALUE_DOC_REQUESTS
     * @uses self::VALUE_OFFLINE_PERSON_SEARCH
     * @uses self::VALUE_OFFLINE_PROPERTY_SEARCH
     * @uses self::VALUE_OFFLINE_DOCUMENT_SEARCH
     * @uses self::VALUE_OFFLINE_INTERDICT_SEARCH
     * @uses self::VALUE_OFFLINE_MULTI_PROPERTY
     * @uses self::VALUE_OFFLINE_NOTIFICATION_SMS
     * @uses self::VALUE_SPIDER_SEARCH
     * @uses self::VALUE_AUTOMATED_VALUATION_FULL
     * @uses self::VALUE_AUTOMATED_VALUATION_SHORT
     * @uses self::VALUE_CONTACT_INFORMATION
     * @uses self::VALUE_DOPROPERTY_SEARCH_FOOTPRINT
     * @uses self::VALUE_BFASANUMBER_SEARCH
     * @uses self::VALUE_DODOCUMENT_TEXT_VERSION
     * @uses self::VALUE_DOTSSEARCH
     * @uses self::VALUE_AUTOMATED_TRACKING
     * @uses self::VALUE_AD_CHECK_ADDRESS
     * @uses self::VALUE_AD_CHECK_REPORT
     * @uses self::VALUE_TRANSFER_INSTRUCTION
     * @uses self::VALUE_TRANSFER_INSTRUCTION_NOTIFICATION_SMS
     * @uses self::VALUE_DEEDOF_SALE
     * @uses self::VALUE_TRANSFER_INSTRUCTION_AMENDMENT
     * @uses self::VALUE_EXPERIAN_CONSUMER_PROFILE
     * @uses self::VALUE_WATCH_REQUEST
     * @uses self::VALUE_WATCH_NOTIFICATION_DEACTIVATION_REQUEST
     * @uses self::VALUE_WATCH_NOTIFICATION_ACTIVATION_REQUEST
     * @uses self::VALUE_WATCH_DEACTIVATION_REQUEST
     * @uses self::VALUE_WATCH_ACTIVATION_REQUEST
     * @uses self::VALUE_WATCH_PRESCRIBED_PURPOSE_REQUEST
     * @uses self::VALUE_WATCH_DELETION_REQUEST
     * @uses self::VALUE_PROP_IQ
     * @uses self::VALUE_MULTI_DOPERSON_SEARCH
     * @uses self::VALUE_OBJECTIONS
     * @uses self::VALUE_AFRI_GIS
     * @uses self::VALUE_WIN_DEED_PROPERTY_SEARCH
     * @uses self::VALUE_WIN_DEED_FARM_LOOKUP
     * @uses self::VALUE_TPNCOMPANY
     * @uses self::VALUE_TPNCONSUMER
     * @uses self::VALUE_TPNPRESCRIBED_PURPOSE
     * @uses self::VALUE_WIN_DEED_SUBURB_REPORT
     * @uses self::VALUE_WIN_DEED_PROPERTY_ADVANCED_SEARCH
     * @uses self::VALUE_JUDGMENT_ENQUIRY_COMPANY
     * @uses self::VALUE_JUDGMENT_ENQUIRY_INDIVIDUAL
     * @uses self::VALUE_JUDGMENT_ENQUIRY_DOCUMENT_COPY
     * @uses self::VALUE_TRACE_ENQUIRY
     * @uses self::VALUE_TUITCTRACE_ENQUIRY
     * @uses self::VALUE_VEHICLE_SEARCH
     * @uses self::VALUE_CIPC_UBER_COMPANY_SEARCH
     * @uses self::VALUE_CIPC_UBER_DIRECTOR_SEARCH
     * @uses self::VALUE_COMPUSCAN_TRACE
     * @uses self::VALUE_COMPUSCAN_TRACE_PRESCRIBED_PURPOSE
     * @uses self::VALUE_TRANS_UNION_ALERTS
     * @uses self::VALUE_TRANS_UNION_VEHICLE_ENQUIRY
     * @uses self::VALUE_COMPUSCAN_CONSUMER_PROFILE
     * @uses self::VALUE_COMPUSCAN_CONSUMER_PROFILE_PRESCRIBED_PURPOSE
     * @uses self::VALUE_DEEDS_OFFICE_PROPERTY_BATCH_SEARCH
     * @uses self::VALUE_DEEDS_OFFICE_PERSON_BATCH_SEARCH
     * @uses self::VALUE_DATA_SERVICES_OFFLINE_PERSON_SEARCH
     * @uses self::VALUE_DATA_SERVICES_OFFLINE_PROPERTY_SEARCH
     * @uses self::VALUE_DATA_SERVICES_OFFLINE_DOCUMENT_SEARCH
     * @uses self::VALUE_DATA_SERVICES_OFFLINE_INTERDICT_SEARCH
     * @uses self::VALUE_DATA_SERVICES_OFFLINE_MULTI_PROPERTY
     * @uses self::VALUE_AGENT_IQ
     * @uses self::VALUE_DATA_SERVICES_SPIDER_SEARCH
     * @uses self::VALUE_OFFLINE_PROPERTY_V_1
     * @uses self::VALUE_WIN_DEED_DATABASE_PROPERTY_V_1
     * @uses self::VALUE_AKTEX_PROPERTY_V_1
     * @uses self::VALUE_DEEDS_WEB_PROPERTY_V_1
     * @uses self::VALUE_XDSTRACE
     * @uses self::VALUE_XDSCONSUMER_TRACE
     * @uses self::VALUE_XDSCONSUMER_PROFILE
     * @uses self::VALUE_HOME_AFFAIRS_IDV
     * @uses self::VALUE_ENATIS_VEHICLE_HISTORY
     * @uses self::VALUE_ENATIS_VEHICLE_DETAILS
     * @uses self::VALUE_ENATIS_OWNER_VEHICLES
     * @uses self::VALUE_VAT_NUMBER
     * @uses self::VALUE_DEEDS_WEB_LPI_CODE_V_1
     * @uses self::VALUE_WIN_DEED_DATABASE_LPI_CODE_V_1
     * @uses self::VALUE_OFFLINE_LPI_CODE_V_1
     * @uses self::VALUE_WIN_DEED_DATABASE_DOCUMENT_SEARCH_V_1
     * @uses self::VALUE_BANK_ACCOUNT_VERIFICATION
     * @uses self::VALUE_TRANS_UNION_CONSUMER_PROFILE_V_1
     * @uses self::VALUE_TRANS_UNION_STATUTORY_DETAILON_FILE
     * @uses self::VALUE_TRANS_UNION_SUBJECT_DEFAULT
     * @uses self::VALUE_TRANS_UNION_PRINCIPAL_DETAIL
     * @uses self::VALUE_TRANS_UNION_ENQUIRY_HISTORY
     * @uses self::VALUE_TRANS_UNION_BANKON_FILE
     * @uses self::VALUE_TRANS_UNION_TRADEON_FILE
     * @uses self::VALUE_TRANS_UNION_DEEDSON_FILE
     * @uses self::VALUE_TRANS_UNION_SCANON_FILE
     * @uses self::VALUE_TRANS_UNION_DYNAMIC_RATING_SMEASSESSMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DOPERSON_SEARCH,
            self::VALUE_DOPROPERTY_SEARCH,
            self::VALUE_DODOCUMENT_SEARCH,
            self::VALUE_DODOCUMENT_REQUEST,
            self::VALUE_DOFARM_LOOKUP,
            self::VALUE_DOINTERDICT_SEARCH,
            self::VALUE_DOTRANSFER_DETAILS,
            self::VALUE_DOTRANSFER_OVERVIEW,
            self::VALUE_UNKNOWN_REQUEST,
            self::VALUE_PASSTHROUGH_SEARCH,
            self::VALUE_DOPROPERTY_LIST_SEARCH,
            self::VALUE_TUITCCONSUMER_PROFILE,
            self::VALUE_TUITCPRINCIPAL_LINK,
            self::VALUE_TUITCBUSINESS_PROFILE,
            self::VALUE_TUITCIDVERIFICATION,
            self::VALUE_TUITCSKIP_TRACE_INDIVIDUAL,
            self::VALUE_TUITCASSET_SEARCH_INDIVIDUAL,
            self::VALUE_TUITCINT_SKIP_TRACE_INDIVIDUAL,
            self::VALUE_TUITCSKIP_TRACE_COMPANY,
            self::VALUE_TUITCASSET_SEARCH_COMPANY,
            self::VALUE_TUITCINT_SKIP_TRACE_COMPANY,
            self::VALUE_TUITCEMPLOYMENT_VERIFICATION,
            self::VALUE_CHEQUE_VERIFICATION,
            self::VALUE_CIPROCOMPANY_SEARCH,
            self::VALUE_CIPRODIRECTOR_SEARCH,
            self::VALUE_SGDIAGRAM_REQUEST,
            self::VALUE_STREETTO_ERF_CONVERSION,
            self::VALUE_ERFTO_STREET_CONVERSION,
            self::VALUE_SCHEME_CONVERSION,
            self::VALUE_CAVPROPERTY_VALUATION_OPTION_1,
            self::VALUE_CAVPROPERTY_VALUATION_OPTION_2,
            self::VALUE_CAVPROPERTY_VALUATION_OPTION_3,
            self::VALUE_HISTORICAL_TRANSFER_SUBURB_RDLIST,
            self::VALUE_HISTORICAL_TRANSFER_OVERVIEW,
            self::VALUE_HISTORICAL_TRANSFER_DETAILS,
            self::VALUE_KORBITEC_STREET_TO_ERF_CONVERSION,
            self::VALUE_KORBITEC_ERF_TO_STREET_CONVERSION,
            self::VALUE_SAS,
            self::VALUE_GISCOE,
            self::VALUE_DOC_REQUESTS,
            self::VALUE_OFFLINE_PERSON_SEARCH,
            self::VALUE_OFFLINE_PROPERTY_SEARCH,
            self::VALUE_OFFLINE_DOCUMENT_SEARCH,
            self::VALUE_OFFLINE_INTERDICT_SEARCH,
            self::VALUE_OFFLINE_MULTI_PROPERTY,
            self::VALUE_OFFLINE_NOTIFICATION_SMS,
            self::VALUE_SPIDER_SEARCH,
            self::VALUE_AUTOMATED_VALUATION_FULL,
            self::VALUE_AUTOMATED_VALUATION_SHORT,
            self::VALUE_CONTACT_INFORMATION,
            self::VALUE_DOPROPERTY_SEARCH_FOOTPRINT,
            self::VALUE_BFASANUMBER_SEARCH,
            self::VALUE_DODOCUMENT_TEXT_VERSION,
            self::VALUE_DOTSSEARCH,
            self::VALUE_AUTOMATED_TRACKING,
            self::VALUE_AD_CHECK_ADDRESS,
            self::VALUE_AD_CHECK_REPORT,
            self::VALUE_TRANSFER_INSTRUCTION,
            self::VALUE_TRANSFER_INSTRUCTION_NOTIFICATION_SMS,
            self::VALUE_DEEDOF_SALE,
            self::VALUE_TRANSFER_INSTRUCTION_AMENDMENT,
            self::VALUE_EXPERIAN_CONSUMER_PROFILE,
            self::VALUE_WATCH_REQUEST,
            self::VALUE_WATCH_NOTIFICATION_DEACTIVATION_REQUEST,
            self::VALUE_WATCH_NOTIFICATION_ACTIVATION_REQUEST,
            self::VALUE_WATCH_DEACTIVATION_REQUEST,
            self::VALUE_WATCH_ACTIVATION_REQUEST,
            self::VALUE_WATCH_PRESCRIBED_PURPOSE_REQUEST,
            self::VALUE_WATCH_DELETION_REQUEST,
            self::VALUE_PROP_IQ,
            self::VALUE_MULTI_DOPERSON_SEARCH,
            self::VALUE_OBJECTIONS,
            self::VALUE_AFRI_GIS,
            self::VALUE_WIN_DEED_PROPERTY_SEARCH,
            self::VALUE_WIN_DEED_FARM_LOOKUP,
            self::VALUE_TPNCOMPANY,
            self::VALUE_TPNCONSUMER,
            self::VALUE_TPNPRESCRIBED_PURPOSE,
            self::VALUE_WIN_DEED_SUBURB_REPORT,
            self::VALUE_WIN_DEED_PROPERTY_ADVANCED_SEARCH,
            self::VALUE_JUDGMENT_ENQUIRY_COMPANY,
            self::VALUE_JUDGMENT_ENQUIRY_INDIVIDUAL,
            self::VALUE_JUDGMENT_ENQUIRY_DOCUMENT_COPY,
            self::VALUE_TRACE_ENQUIRY,
            self::VALUE_TUITCTRACE_ENQUIRY,
            self::VALUE_VEHICLE_SEARCH,
            self::VALUE_CIPC_UBER_COMPANY_SEARCH,
            self::VALUE_CIPC_UBER_DIRECTOR_SEARCH,
            self::VALUE_COMPUSCAN_TRACE,
            self::VALUE_COMPUSCAN_TRACE_PRESCRIBED_PURPOSE,
            self::VALUE_TRANS_UNION_ALERTS,
            self::VALUE_TRANS_UNION_VEHICLE_ENQUIRY,
            self::VALUE_COMPUSCAN_CONSUMER_PROFILE,
            self::VALUE_COMPUSCAN_CONSUMER_PROFILE_PRESCRIBED_PURPOSE,
            self::VALUE_DEEDS_OFFICE_PROPERTY_BATCH_SEARCH,
            self::VALUE_DEEDS_OFFICE_PERSON_BATCH_SEARCH,
            self::VALUE_DATA_SERVICES_OFFLINE_PERSON_SEARCH,
            self::VALUE_DATA_SERVICES_OFFLINE_PROPERTY_SEARCH,
            self::VALUE_DATA_SERVICES_OFFLINE_DOCUMENT_SEARCH,
            self::VALUE_DATA_SERVICES_OFFLINE_INTERDICT_SEARCH,
            self::VALUE_DATA_SERVICES_OFFLINE_MULTI_PROPERTY,
            self::VALUE_AGENT_IQ,
            self::VALUE_DATA_SERVICES_SPIDER_SEARCH,
            self::VALUE_OFFLINE_PROPERTY_V_1,
            self::VALUE_WIN_DEED_DATABASE_PROPERTY_V_1,
            self::VALUE_AKTEX_PROPERTY_V_1,
            self::VALUE_DEEDS_WEB_PROPERTY_V_1,
            self::VALUE_XDSTRACE,
            self::VALUE_XDSCONSUMER_TRACE,
            self::VALUE_XDSCONSUMER_PROFILE,
            self::VALUE_HOME_AFFAIRS_IDV,
            self::VALUE_ENATIS_VEHICLE_HISTORY,
            self::VALUE_ENATIS_VEHICLE_DETAILS,
            self::VALUE_ENATIS_OWNER_VEHICLES,
            self::VALUE_VAT_NUMBER,
            self::VALUE_DEEDS_WEB_LPI_CODE_V_1,
            self::VALUE_WIN_DEED_DATABASE_LPI_CODE_V_1,
            self::VALUE_OFFLINE_LPI_CODE_V_1,
            self::VALUE_WIN_DEED_DATABASE_DOCUMENT_SEARCH_V_1,
            self::VALUE_BANK_ACCOUNT_VERIFICATION,
            self::VALUE_TRANS_UNION_CONSUMER_PROFILE_V_1,
            self::VALUE_TRANS_UNION_STATUTORY_DETAILON_FILE,
            self::VALUE_TRANS_UNION_SUBJECT_DEFAULT,
            self::VALUE_TRANS_UNION_PRINCIPAL_DETAIL,
            self::VALUE_TRANS_UNION_ENQUIRY_HISTORY,
            self::VALUE_TRANS_UNION_BANKON_FILE,
            self::VALUE_TRANS_UNION_TRADEON_FILE,
            self::VALUE_TRANS_UNION_DEEDSON_FILE,
            self::VALUE_TRANS_UNION_SCANON_FILE,
            self::VALUE_TRANS_UNION_DYNAMIC_RATING_SMEASSESSMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
