<?php

namespace EnumType;

/**
 * This class stands for PrintoutType EnumType
 * @subpackage Enumerations
 */
class PrintoutType
{
    /**
     * Constant for value 'Rtf'
     * @return string 'Rtf'
     */
    const VALUE_RTF = 'Rtf';
    /**
     * Constant for value 'Pdf'
     * @return string 'Pdf'
     */
    const VALUE_PDF = 'Pdf';
    /**
     * Constant for value 'GhostDraft'
     * @return string 'GhostDraft'
     */
    const VALUE_GHOST_DRAFT = 'GhostDraft';
    /**
     * Constant for value 'Tiff'
     * @return string 'Tiff'
     */
    const VALUE_TIFF = 'Tiff';
    /**
     * Constant for value 'Html'
     * @return string 'Html'
     */
    const VALUE_HTML = 'Html';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RTF
     * @uses self::VALUE_PDF
     * @uses self::VALUE_GHOST_DRAFT
     * @uses self::VALUE_TIFF
     * @uses self::VALUE_HTML
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RTF,
            self::VALUE_PDF,
            self::VALUE_GHOST_DRAFT,
            self::VALUE_TIFF,
            self::VALUE_HTML,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
