<?php

namespace EnumType;

/**
 * This class stands for Eula EnumType
 * @subpackage Enumerations
 */
class Eula
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'WinCredit'
     * @return string 'WinCredit'
     */
    const VALUE_WIN_CREDIT = 'WinCredit';
    /**
     * Constant for value 'WinDeed'
     * @return string 'WinDeed'
     */
    const VALUE_WIN_DEED = 'WinDeed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_WIN_CREDIT
     * @uses self::VALUE_WIN_DEED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_WIN_CREDIT,
            self::VALUE_WIN_DEED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
