<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMemberBase ArrayType
 * @subpackage Arrays
 */
class ArrayOfMemberBase extends AbstractStructArrayBase
{
    /**
     * The MemberBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MemberBase[]
     */
    public $MemberBase;
    /**
     * Constructor method for ArrayOfMemberBase
     * @uses ArrayOfMemberBase::setMemberBase()
     * @param \StructType\MemberBase[] $memberBase
     */
    public function __construct(array $memberBase = array())
    {
        $this
            ->setMemberBase($memberBase);
    }
    /**
     * Get MemberBase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MemberBase[]|null
     */
    public function getMemberBase()
    {
        return isset($this->MemberBase) ? $this->MemberBase : null;
    }
    /**
     * Set MemberBase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MemberBase[] $memberBase
     * @return \ArrayType\ArrayOfMemberBase
     */
    public function setMemberBase(array $memberBase = array())
    {
        foreach ($memberBase as $arrayOfMemberBaseMemberBaseItem) {
            // validation for constraint: itemType
            if (!$arrayOfMemberBaseMemberBaseItem instanceof \StructType\MemberBase) {
                throw new \InvalidArgumentException(sprintf('The MemberBase property can only contain items of \StructType\MemberBase, "%s" given', is_object($arrayOfMemberBaseMemberBaseItem) ? get_class($arrayOfMemberBaseMemberBaseItem) : gettype($arrayOfMemberBaseMemberBaseItem)), __LINE__);
            }
        }
        if (is_null($memberBase) || (is_array($memberBase) && empty($memberBase))) {
            unset($this->MemberBase);
        } else {
            $this->MemberBase = $memberBase;
        }
        return $this;
    }
    /**
     * Add item to MemberBase value
     * @throws \InvalidArgumentException
     * @param \StructType\MemberBase $item
     * @return \ArrayType\ArrayOfMemberBase
     */
    public function addToMemberBase(\StructType\MemberBase $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MemberBase) {
            throw new \InvalidArgumentException(sprintf('The MemberBase property can only contain items of \StructType\MemberBase, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MemberBase[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MemberBase|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MemberBase|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MemberBase|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MemberBase|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MemberBase|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MemberBase
     */
    public function getAttributeName()
    {
        return 'MemberBase';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMemberBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
