<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCompanyListItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfCompanyListItem extends AbstractStructArrayBase
{
    /**
     * The CompanyListItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CompanyListItem[]
     */
    public $CompanyListItem;
    /**
     * Constructor method for ArrayOfCompanyListItem
     * @uses ArrayOfCompanyListItem::setCompanyListItem()
     * @param \StructType\CompanyListItem[] $companyListItem
     */
    public function __construct(array $companyListItem = array())
    {
        $this
            ->setCompanyListItem($companyListItem);
    }
    /**
     * Get CompanyListItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CompanyListItem[]|null
     */
    public function getCompanyListItem()
    {
        return isset($this->CompanyListItem) ? $this->CompanyListItem : null;
    }
    /**
     * Set CompanyListItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyListItem[] $companyListItem
     * @return \ArrayType\ArrayOfCompanyListItem
     */
    public function setCompanyListItem(array $companyListItem = array())
    {
        foreach ($companyListItem as $arrayOfCompanyListItemCompanyListItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfCompanyListItemCompanyListItemItem instanceof \StructType\CompanyListItem) {
                throw new \InvalidArgumentException(sprintf('The CompanyListItem property can only contain items of \StructType\CompanyListItem, "%s" given', is_object($arrayOfCompanyListItemCompanyListItemItem) ? get_class($arrayOfCompanyListItemCompanyListItemItem) : gettype($arrayOfCompanyListItemCompanyListItemItem)), __LINE__);
            }
        }
        if (is_null($companyListItem) || (is_array($companyListItem) && empty($companyListItem))) {
            unset($this->CompanyListItem);
        } else {
            $this->CompanyListItem = $companyListItem;
        }
        return $this;
    }
    /**
     * Add item to CompanyListItem value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyListItem $item
     * @return \ArrayType\ArrayOfCompanyListItem
     */
    public function addToCompanyListItem(\StructType\CompanyListItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyListItem) {
            throw new \InvalidArgumentException(sprintf('The CompanyListItem property can only contain items of \StructType\CompanyListItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CompanyListItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CompanyListItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CompanyListItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CompanyListItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CompanyListItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CompanyListItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CompanyListItem
     */
    public function getAttributeName()
    {
        return 'CompanyListItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCompanyListItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
