<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCapital ArrayType
 * @subpackage Arrays
 */
class ArrayOfCapital extends AbstractStructArrayBase
{
    /**
     * The Capital
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Capital[]
     */
    public $Capital;
    /**
     * Constructor method for ArrayOfCapital
     * @uses ArrayOfCapital::setCapital()
     * @param \StructType\Capital[] $capital
     */
    public function __construct(array $capital = array())
    {
        $this
            ->setCapital($capital);
    }
    /**
     * Get Capital value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Capital[]|null
     */
    public function getCapital()
    {
        return isset($this->Capital) ? $this->Capital : null;
    }
    /**
     * Set Capital value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Capital[] $capital
     * @return \ArrayType\ArrayOfCapital
     */
    public function setCapital(array $capital = array())
    {
        foreach ($capital as $arrayOfCapitalCapitalItem) {
            // validation for constraint: itemType
            if (!$arrayOfCapitalCapitalItem instanceof \StructType\Capital) {
                throw new \InvalidArgumentException(sprintf('The Capital property can only contain items of \StructType\Capital, "%s" given', is_object($arrayOfCapitalCapitalItem) ? get_class($arrayOfCapitalCapitalItem) : gettype($arrayOfCapitalCapitalItem)), __LINE__);
            }
        }
        if (is_null($capital) || (is_array($capital) && empty($capital))) {
            unset($this->Capital);
        } else {
            $this->Capital = $capital;
        }
        return $this;
    }
    /**
     * Add item to Capital value
     * @throws \InvalidArgumentException
     * @param \StructType\Capital $item
     * @return \ArrayType\ArrayOfCapital
     */
    public function addToCapital(\StructType\Capital $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Capital) {
            throw new \InvalidArgumentException(sprintf('The Capital property can only contain items of \StructType\Capital, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Capital[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Capital|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Capital|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Capital|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Capital|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Capital|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Capital
     */
    public function getAttributeName()
    {
        return 'Capital';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCapital
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
