<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveResponse StructType
 * @subpackage Structs
 */
class RetrieveResponse extends AbstractStructBase
{
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $reference;
    /**
     * Constructor method for RetrieveResponse
     * @uses RetrieveResponse::setReference()
     * @param int $reference
     */
    public function __construct($reference = null)
    {
        $this
            ->setReference($reference);
    }
    /**
     * Get reference value
     * @return int
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param int $reference
     * @return \StructType\RetrieveResponse
     */
    public function setReference($reference = null)
    {
        // validation for constraint: int
        if (!is_null($reference) && !is_numeric($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetrieveResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
