<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestBase StructType
 * @subpackage Structs
 */
abstract class RequestBase extends AbstractStructBase
{
    /**
     * The ParentRequestId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ParentRequestId;
    /**
     * The SessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $SessionId;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Requester
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requester;
    /**
     * Constructor method for RequestBase
     * @uses RequestBase::setParentRequestId()
     * @uses RequestBase::setSessionId()
     * @uses RequestBase::setReference()
     * @uses RequestBase::setRequester()
     * @param int $parentRequestId
     * @param string $sessionId
     * @param string $reference
     * @param string $requester
     */
    public function __construct($parentRequestId = null, $sessionId = null, $reference = null, $requester = null)
    {
        $this
            ->setParentRequestId($parentRequestId)
            ->setSessionId($sessionId)
            ->setReference($reference)
            ->setRequester($requester);
    }
    /**
     * Get ParentRequestId value
     * @return int
     */
    public function getParentRequestId()
    {
        return $this->ParentRequestId;
    }
    /**
     * Set ParentRequestId value
     * @param int $parentRequestId
     * @return \StructType\RequestBase
     */
    public function setParentRequestId($parentRequestId = null)
    {
        // validation for constraint: int
        if (!is_null($parentRequestId) && !is_numeric($parentRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentRequestId)), __LINE__);
        }
        $this->ParentRequestId = $parentRequestId;
        return $this;
    }
    /**
     * Get SessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param string $sessionId
     * @return \StructType\RequestBase
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sessionId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($sessionId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\RequestBase
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Requester value
     * @return string|null
     */
    public function getRequester()
    {
        return $this->Requester;
    }
    /**
     * Set Requester value
     * @param string $requester
     * @return \StructType\RequestBase
     */
    public function setRequester($requester = null)
    {
        // validation for constraint: string
        if (!is_null($requester) && !is_string($requester)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requester)), __LINE__);
        }
        $this->Requester = $requester;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
