<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PasswordActivationKeyIsValid StructType
 * @subpackage Structs
 */
class PasswordActivationKeyIsValid extends AbstractStructBase
{
    /**
     * The activationKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $activationKey;
    /**
     * Constructor method for PasswordActivationKeyIsValid
     * @uses PasswordActivationKeyIsValid::setActivationKey()
     * @param string $activationKey
     */
    public function __construct($activationKey = null)
    {
        $this
            ->setActivationKey($activationKey);
    }
    /**
     * Get activationKey value
     * @return string
     */
    public function getActivationKey()
    {
        return $this->activationKey;
    }
    /**
     * Set activationKey value
     * @param string $activationKey
     * @return \StructType\PasswordActivationKeyIsValid
     */
    public function setActivationKey($activationKey = null)
    {
        // validation for constraint: pattern
        if (is_scalar($activationKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $activationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($activationKey, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($activationKey) && !is_string($activationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activationKey)), __LINE__);
        }
        $this->activationKey = $activationKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PasswordActivationKeyIsValid
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
