<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NaturalUberLink StructType
 * @subpackage Structs
 */
class NaturalUberLink extends UberLinkBase
{
    /**
     * The ActiveDirectorshipCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ActiveDirectorshipCount;
    /**
     * The InactiveDirectorshipCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $InactiveDirectorshipCount;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The IdNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdNumber;
    /**
     * Constructor method for NaturalUberLink
     * @uses NaturalUberLink::setActiveDirectorshipCount()
     * @uses NaturalUberLink::setInactiveDirectorshipCount()
     * @uses NaturalUberLink::setFirstName()
     * @uses NaturalUberLink::setSurname()
     * @uses NaturalUberLink::setIdNumber()
     * @param int $activeDirectorshipCount
     * @param int $inactiveDirectorshipCount
     * @param string $firstName
     * @param string $surname
     * @param string $idNumber
     */
    public function __construct($activeDirectorshipCount = null, $inactiveDirectorshipCount = null, $firstName = null, $surname = null, $idNumber = null)
    {
        $this
            ->setActiveDirectorshipCount($activeDirectorshipCount)
            ->setInactiveDirectorshipCount($inactiveDirectorshipCount)
            ->setFirstName($firstName)
            ->setSurname($surname)
            ->setIdNumber($idNumber);
    }
    /**
     * Get ActiveDirectorshipCount value
     * @return int
     */
    public function getActiveDirectorshipCount()
    {
        return $this->ActiveDirectorshipCount;
    }
    /**
     * Set ActiveDirectorshipCount value
     * @param int $activeDirectorshipCount
     * @return \StructType\NaturalUberLink
     */
    public function setActiveDirectorshipCount($activeDirectorshipCount = null)
    {
        // validation for constraint: int
        if (!is_null($activeDirectorshipCount) && !is_numeric($activeDirectorshipCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activeDirectorshipCount)), __LINE__);
        }
        $this->ActiveDirectorshipCount = $activeDirectorshipCount;
        return $this;
    }
    /**
     * Get InactiveDirectorshipCount value
     * @return int
     */
    public function getInactiveDirectorshipCount()
    {
        return $this->InactiveDirectorshipCount;
    }
    /**
     * Set InactiveDirectorshipCount value
     * @param int $inactiveDirectorshipCount
     * @return \StructType\NaturalUberLink
     */
    public function setInactiveDirectorshipCount($inactiveDirectorshipCount = null)
    {
        // validation for constraint: int
        if (!is_null($inactiveDirectorshipCount) && !is_numeric($inactiveDirectorshipCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inactiveDirectorshipCount)), __LINE__);
        }
        $this->InactiveDirectorshipCount = $inactiveDirectorshipCount;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\NaturalUberLink
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\NaturalUberLink
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get IdNumber value
     * @return string|null
     */
    public function getIdNumber()
    {
        return $this->IdNumber;
    }
    /**
     * Set IdNumber value
     * @param string $idNumber
     * @return \StructType\NaturalUberLink
     */
    public function setIdNumber($idNumber = null)
    {
        // validation for constraint: string
        if (!is_null($idNumber) && !is_string($idNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idNumber)), __LINE__);
        }
        $this->IdNumber = $idNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NaturalUberLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
